/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.client.impl.remote.search;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.epics.pvaccess.client.impl.remote.ClientContextImpl;
import org.epics.pvaccess.client.impl.remote.search.ChannelSearchManager;
import org.epics.pvaccess.client.impl.remote.search.SearchInstance;
import org.epics.pvaccess.impl.remote.ProtocolType;
import org.epics.pvaccess.impl.remote.TransportSendControl;
import org.epics.pvaccess.impl.remote.udp.BlockingUDPTransport;
import org.epics.pvaccess.impl.remote.utils.GUID;
import org.epics.pvaccess.util.InetAddressUtil;
import org.epics.pvdata.misc.SerializeHelper;
import org.epics.pvdata.misc.Timer;
import org.epics.pvdata.misc.TimerFactory;
import org.epics.pvdata.pv.Field;
import org.epics.pvdata.pv.SerializableControl;

public class SimpleChannelSearchManagerImpl
implements ChannelSearchManager,
Timer.TimerCallback,
Runnable {
    private final ClientContextImpl context;
    private volatile boolean canceled = false;
    private final AtomicInteger sequenceNumber = new AtomicInteger(0);
    private final ByteBuffer sendBuffer;
    private final Map<Integer, SearchInstance> channels = Collections.synchronizedMap(new HashMap());
    private final ArrayList<SearchInstance> immediateSearch = new ArrayList(128);
    private final Timer.TimerNode timerNode;
    private long lastTimeSent = 0L;
    private static final double ATOMIC_PERIOD = 0.225;
    private static final int PERIOD_JITTER_MS = 25;
    private final short responsePort;
    private final InetAddress responseAddress;
    private static final int DATA_COUNT_POSITION = 39;
    private static final int CAST_POSITION = 12;
    private static final int PAYLOAD_POSITION = 4;
    private static final TransportSendControl mockTransportSendControl = new TransportSendControl(){

        @Override
        public void endMessage() {
        }

        @Override
        public void flush(boolean lastMessageCompleted) {
        }

        @Override
        public void setRecipient(InetSocketAddress sendTo) {
        }

        @Override
        public void startMessage(byte command, int ensureCapacity) {
        }

        public void ensureBuffer(int size) {
        }

        public void alignBuffer(int alignment) {
            throw new UnsupportedOperationException("alignBuffer not supported");
        }

        public void flushSerializeBuffer() {
        }

        public void cachedSerialize(Field field, ByteBuffer buffer) {
            field.serialize(buffer, (SerializableControl)this);
        }
    };
    private static final int DEFAULT_COUNT_VALUE = 1;
    private static final int BOOST_VALUE = 1;
    private static final int MAX_COUNT_VALUE = 256;
    private static final int MAX_FALLBACK_COUNT_VALUE = 129;
    private static final int MAX_FRAMES_AT_ONCE = 10;
    private static final int DELAY_BETWEEN_FRAMES_MS = 50;

    public SimpleChannelSearchManagerImpl(ClientContextImpl context) {
        this.context = context;
        InetSocketAddress responseSocketAddress = context.getSearchTransport().getRemoteAddress();
        this.responsePort = (short)responseSocketAddress.getPort();
        this.responseAddress = responseSocketAddress.getAddress();
        this.sendBuffer = ByteBuffer.allocate(1440);
        this.initializeSendBuffer();
        double period = 0.225 + (double)(new Random().nextInt(51) - 25) / 1000.0;
        this.timerNode = TimerFactory.createNode((Timer.TimerCallback)this);
        context.getTimer().schedulePeriodic(this.timerNode, period, period);
        new Thread((Runnable)this, "pvAccess immediate-search").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.canceled) {
            try {
                SearchInstance[] sis;
                ArrayList<SearchInstance> arrayList = this.immediateSearch;
                synchronized (arrayList) {
                    try {
                        if (this.immediateSearch.size() == 0) {
                            this.immediateSearch.wait();
                        }
                        if (this.canceled) {
                            return;
                        }
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                ArrayList<SearchInstance> arrayList2 = this.immediateSearch;
                synchronized (arrayList2) {
                    if (this.immediateSearch.size() == 0) {
                        return;
                    }
                    sis = new SearchInstance[this.immediateSearch.size()];
                    this.immediateSearch.toArray(sis);
                    this.immediateSearch.clear();
                }
                this.send(sis);
            }
            catch (Exception th) {
                th.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void cancel() {
        if (this.canceled) {
            return;
        }
        this.canceled = true;
        ArrayList<SearchInstance> arrayList = this.immediateSearch;
        synchronized (arrayList) {
            this.immediateSearch.notifyAll();
        }
        this.timerNode.cancel();
    }

    private void initializeSendBuffer() {
        this.sendBuffer.clear();
        this.sendBuffer.put((byte)-54);
        this.sendBuffer.put((byte)1);
        this.sendBuffer.put((byte)-128);
        this.sendBuffer.put((byte)3);
        this.sendBuffer.putInt(27);
        this.sendBuffer.putInt(this.sequenceNumber.incrementAndGet());
        this.sendBuffer.put((byte)0);
        this.sendBuffer.put((byte)0);
        this.sendBuffer.putShort((short)0);
        InetAddressUtil.encodeAsIPv6Address(this.sendBuffer, this.responseAddress);
        this.sendBuffer.putShort(this.responsePort);
        this.sendBuffer.put((byte)1);
        SerializeHelper.serializeString((String)ProtocolType.tcp.name(), (ByteBuffer)this.sendBuffer);
        this.sendBuffer.putShort((short)0);
    }

    private synchronized void flushSendBuffer() {
        this.sendBuffer.put(12, (byte)-128);
        this.context.getSearchTransport().send(this.sendBuffer, BlockingUDPTransport.InetAddressType.UNICAST);
        this.sendBuffer.put(12, (byte)0);
        this.context.getSearchTransport().send(this.sendBuffer, BlockingUDPTransport.InetAddressType.BROADCAST_MULTICAST);
        this.initializeSendBuffer();
    }

    private static boolean generateSearchRequestMessage(SearchInstance si, ByteBuffer requestMessage, TransportSendControl control) {
        short dataCount = requestMessage.getShort(39);
        if ((dataCount = (short)(dataCount + 1)) >= Short.MAX_VALUE) {
            return false;
        }
        String name = si.getChannelName();
        int addedPayloadSize = 4 + (5 + name.length());
        if (requestMessage.remaining() < addedPayloadSize) {
            return false;
        }
        requestMessage.putInt(si.getChannelID());
        SerializeHelper.serializeString((String)name, (ByteBuffer)requestMessage, (SerializableControl)control);
        requestMessage.putInt(4, requestMessage.position() - 8);
        requestMessage.putShort(39, dataCount);
        return true;
    }

    private synchronized boolean generateSearchRequestMessage(SearchInstance channel, boolean allowNewFrame, boolean flush) {
        boolean success = SimpleChannelSearchManagerImpl.generateSearchRequestMessage(channel, this.sendBuffer, mockTransportSendControl);
        if (!success) {
            this.flushSendBuffer();
            if (allowNewFrame) {
                SimpleChannelSearchManagerImpl.generateSearchRequestMessage(channel, this.sendBuffer, mockTransportSendControl);
            }
            if (flush) {
                this.flushSendBuffer();
            }
            return true;
        }
        if (flush) {
            this.flushSendBuffer();
        }
        return flush;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int registeredCount() {
        Map<Integer, SearchInstance> map = this.channels;
        synchronized (map) {
            return this.channels.size();
        }
    }

    @Override
    public void register(SearchInstance channel) {
        this.register(channel, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(SearchInstance channel, boolean penalize) {
        if (this.canceled) {
            return;
        }
        Object object = this.channels;
        synchronized (object) {
            this.channels.put(channel.getChannelID(), channel);
            channel.getUserValue().set(penalize ? 129 : 1);
        }
        object = this.immediateSearch;
        synchronized (object) {
            this.immediateSearch.add(channel);
            if (this.immediateSearch.size() == 1) {
                this.immediateSearch.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(SearchInstance channel) {
        Map<Integer, SearchInstance> map = this.channels;
        synchronized (map) {
            this.channels.remove(channel.getChannelID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void searchResponse(GUID guid, int cid, int seqNo, byte minorRevision, InetSocketAddress serverAddress) {
        SearchInstance si;
        Map<Integer, SearchInstance> map = this.channels;
        synchronized (map) {
            si = this.channels.remove(cid);
        }
        if (si == null) {
            si = this.context.getChannel(cid);
            if (si != null) {
                si.searchResponse(guid, minorRevision, serverAddress);
            }
            return;
        }
        si.searchResponse(guid, minorRevision, serverAddress);
    }

    @Override
    public void newServerDetected() {
        this.boost();
        this.callback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void boost() {
        Map<Integer, SearchInstance> map = this.channels;
        synchronized (map) {
            for (SearchInstance searchInstance : this.channels.values()) {
                searchInstance.getUserValue().set(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callback() {
        SimpleChannelSearchManagerImpl simpleChannelSearchManagerImpl = this;
        synchronized (simpleChannelSearchManagerImpl) {
            long now = System.currentTimeMillis();
            if (now - this.lastTimeSent < 100L) {
                return;
            }
            this.lastTimeSent = now;
        }
        try {
            SearchInstance[] sis;
            Map<Integer, SearchInstance> map = this.channels;
            synchronized (map) {
                if (this.channels.size() == 0) {
                    return;
                }
                sis = new SearchInstance[this.channels.size()];
                this.channels.values().toArray(sis);
            }
            this.send(sis);
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
    }

    private static boolean isPowerOfTwo(int x) {
        return x > 0 && (x & x - 1) == 0;
    }

    private void send(SearchInstance[] sis) throws InterruptedException {
        if (sis.length == 0) {
            return;
        }
        int count = 0;
        int frameSent = 0;
        for (SearchInstance si : sis) {
            boolean skip;
            int countValue = si.getUserValue().get();
            boolean bl = skip = !SimpleChannelSearchManagerImpl.isPowerOfTwo(countValue);
            if (countValue == 256) {
                si.getUserValue().set(129);
            } else {
                si.getUserValue().incrementAndGet();
            }
            if (skip) continue;
            ++count;
            if (this.generateSearchRequestMessage(si, true, false)) {
                ++frameSent;
            }
            if (frameSent != 10) continue;
            Thread.sleep(50L);
            frameSent = 0;
        }
        if (count > 0) {
            this.flushSendBuffer();
        }
    }

    public void timerStopped() {
    }
}

