/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.client.impl.remote.handlers;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import org.epics.pvaccess.client.impl.remote.ClientContextImpl;
import org.epics.pvaccess.client.impl.remote.handlers.AbstractClientResponseHandler;
import org.epics.pvaccess.client.impl.remote.search.ChannelSearchManager;
import org.epics.pvaccess.impl.remote.Transport;
import org.epics.pvaccess.impl.remote.utils.GUID;
import org.epics.pvdata.misc.SerializeHelper;
import org.epics.pvdata.pv.DeserializableControl;

public class SearchResponseHandler
extends AbstractClientResponseHandler {
    public SearchResponseHandler(ClientContextImpl context) {
        super(context, "Search response");
    }

    @Override
    public void handleResponse(InetSocketAddress responseFrom, Transport transport, byte version, byte command, int payloadSize, ByteBuffer payloadBuffer) {
        boolean found;
        InetAddress addr;
        super.handleResponse(responseFrom, transport, version, command, payloadSize, payloadBuffer);
        transport.ensureData(34);
        byte[] guid = new byte[12];
        payloadBuffer.get(guid);
        int searchSequenceId = payloadBuffer.getInt();
        byte[] byteAddress = new byte[16];
        payloadBuffer.get(byteAddress);
        int port = payloadBuffer.getShort() & 0xFFFF;
        try {
            addr = InetAddress.getByAddress(byteAddress);
        }
        catch (UnknownHostException e) {
            this.context.getLogger().log(Level.FINER, "Invalid address '" + new String(byteAddress) + "' in search response received from: " + responseFrom, e);
            return;
        }
        responseFrom = !addr.isAnyLocalAddress() ? new InetSocketAddress(addr, port) : new InetSocketAddress(responseFrom.getAddress(), port);
        SerializeHelper.deserializeString((ByteBuffer)payloadBuffer, (DeserializableControl)transport);
        transport.ensureData(1);
        boolean bl = found = payloadBuffer.get() != 0;
        if (!found) {
            return;
        }
        GUID serverGUID = new GUID(guid);
        ChannelSearchManager csm = this.context.getChannelSearchManager();
        int count = payloadBuffer.getShort() & 0xFFFF;
        for (int i = 0; i < count; ++i) {
            transport.ensureData(4);
            int cid = payloadBuffer.getInt();
            csm.searchResponse(serverGUID, cid, searchSequenceId, version, responseFrom);
        }
    }
}

