/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.client.impl.remote.handlers;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import org.epics.pvaccess.client.impl.remote.ClientContextImpl;
import org.epics.pvaccess.client.impl.remote.handlers.AbstractClientResponseHandler;
import org.epics.pvaccess.impl.remote.Transport;
import org.epics.pvaccess.impl.remote.udp.BlockingUDPTransport;
import org.epics.pvaccess.util.InetAddressUtil;

public class SearchHandler
extends AbstractClientResponseHandler {
    public SearchHandler(ClientContextImpl context) {
        super(context, "Search request");
    }

    @Override
    public void handleResponse(InetSocketAddress responseFrom, Transport transport, byte version, byte command, int payloadSize, ByteBuffer payloadBuffer) {
        BlockingUDPTransport bt;
        InetAddress addr;
        super.handleResponse(responseFrom, transport, version, command, payloadSize, payloadBuffer);
        transport.ensureData(26);
        int startPosition = payloadBuffer.position();
        payloadBuffer.getInt();
        byte qosCode = payloadBuffer.get();
        payloadBuffer.get();
        payloadBuffer.getShort();
        byte[] byteAddress = new byte[16];
        payloadBuffer.get(byteAddress);
        int port = payloadBuffer.getShort() & 0xFFFF;
        try {
            addr = InetAddress.getByAddress(byteAddress);
        }
        catch (UnknownHostException e) {
            this.context.getLogger().log(Level.FINER, "Invalid address '" + new String(byteAddress) + "' in search response received from: " + responseFrom, e);
            return;
        }
        responseFrom = !addr.isAnyLocalAddress() ? new InetSocketAddress(addr, port) : new InetSocketAddress(responseFrom.getAddress(), port);
        if ((qosCode & 0x80) == 128 && (bt = this.context.getSearchTransport()) != null) {
            payloadBuffer.put(startPosition + 4, (byte)(qosCode & 0xFFFFFF7F));
            payloadBuffer.position(startPosition + 8);
            InetAddressUtil.encodeAsIPv6Address(payloadBuffer, responseFrom.getAddress());
            payloadBuffer.position(payloadBuffer.limit());
            bt.send(payloadBuffer, this.context.getLocalMulticastAddress());
            return;
        }
    }
}

