/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.client.impl.remote.handlers;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.epics.pvaccess.client.impl.remote.ClientContextImpl;
import org.epics.pvaccess.client.impl.remote.handlers.AbstractClientResponseHandler;
import org.epics.pvaccess.impl.remote.Transport;
import org.epics.pvaccess.impl.remote.request.DataResponse;

public class MultipleDataResponseHandler
extends AbstractClientResponseHandler {
    public MultipleDataResponseHandler(ClientContextImpl context) {
        super(context, "Multiple data response");
    }

    @Override
    public void handleResponse(InetSocketAddress responseFrom, Transport transport, byte version, byte command, int payloadSize, ByteBuffer payloadBuffer) {
        super.handleResponse(responseFrom, transport, version, command, payloadSize, payloadBuffer);
        while (true) {
            transport.ensureData(4);
            int ioid = payloadBuffer.getInt();
            if (ioid == 0) {
                return;
            }
            DataResponse nrr = (DataResponse)this.context.getResponseRequest(ioid);
            if (nrr == null) {
                this.context.getLogger().severe("Unknown request ID within packed response message, all subsequent responses in this message will be lost!");
                return;
            }
            nrr.response(transport, version, payloadBuffer);
        }
    }
}

