/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.client.impl.remote.handlers;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.epics.pvaccess.client.impl.remote.ClientContextImpl;
import org.epics.pvaccess.client.impl.remote.handlers.AbstractClientResponseHandler;
import org.epics.pvaccess.impl.remote.Transport;
import org.epics.pvaccess.impl.remote.request.ResponseRequest;
import org.epics.pvdata.misc.SerializeHelper;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.MessageType;
import org.epics.pvdata.pv.Requester;

public class MessageHandler
extends AbstractClientResponseHandler {
    public MessageHandler(ClientContextImpl context) {
        super(context, "Message");
    }

    @Override
    public void handleResponse(InetSocketAddress responseFrom, Transport transport, byte version, byte command, int payloadSize, ByteBuffer payloadBuffer) {
        Requester requester;
        super.handleResponse(responseFrom, transport, version, command, payloadSize, payloadBuffer);
        transport.ensureData(5);
        ResponseRequest nrr = this.context.getResponseRequest(payloadBuffer.getInt());
        if (nrr != null && (requester = nrr.getRequester()) != null) {
            MessageType type = MessageType.values()[payloadBuffer.get()];
            String message = SerializeHelper.deserializeString((ByteBuffer)payloadBuffer, (DeserializableControl)transport);
            requester.message(message, type);
        }
    }
}

