/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.client.impl.remote.handlers;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.epics.pvaccess.PVFactory;
import org.epics.pvaccess.client.impl.remote.ChannelImpl;
import org.epics.pvaccess.client.impl.remote.ClientContextImpl;
import org.epics.pvaccess.client.impl.remote.handlers.AbstractClientResponseHandler;
import org.epics.pvaccess.impl.remote.Transport;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.Status;
import org.epics.pvdata.pv.StatusCreate;

public class CreateChannelHandler
extends AbstractClientResponseHandler {
    private static final StatusCreate statusCreate = PVFactory.getStatusCreate();

    public CreateChannelHandler(ClientContextImpl context) {
        super(context, "Create channel");
    }

    @Override
    public void handleResponse(InetSocketAddress responseFrom, Transport transport, byte version, byte command, int payloadSize, ByteBuffer payloadBuffer) {
        super.handleResponse(responseFrom, transport, version, command, payloadSize, payloadBuffer);
        transport.ensureData(8);
        int cid = payloadBuffer.getInt();
        int sid = payloadBuffer.getInt();
        Status status = statusCreate.deserializeStatus(payloadBuffer, (DeserializableControl)transport);
        ChannelImpl channel = this.context.getChannel(cid);
        if (channel != null) {
            if (!status.isSuccess()) {
                String logMessage = "Failed to create channel '" + channel.getChannelName() + "': " + status.getMessage();
                String stackDump = status.getStackDump();
                if (stackDump != null && !stackDump.isEmpty()) {
                    logMessage = logMessage + "\n" + stackDump;
                }
                this.context.getLogger().fine(logMessage);
                channel.createChannelFailed();
                return;
            }
            channel.connectionCompleted(sid);
        }
    }
}

