/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.client.impl.remote.handlers;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import org.epics.pvaccess.PVFactory;
import org.epics.pvaccess.client.impl.remote.ClientContextImpl;
import org.epics.pvaccess.client.impl.remote.handlers.AbstractClientResponseHandler;
import org.epics.pvaccess.impl.remote.Transport;
import org.epics.pvdata.misc.SerializeHelper;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.Field;
import org.epics.pvdata.pv.FieldCreate;
import org.epics.pvdata.pv.PVDataCreate;
import org.epics.pvdata.pv.PVField;

public class BeaconHandler
extends AbstractClientResponseHandler {
    private static final PVDataCreate pvDataCreate = PVFactory.getPVDataCreate();
    private static final FieldCreate fieldCreate = PVFactory.getFieldCreate();

    public BeaconHandler(ClientContextImpl context) {
        super(context, "Beacon");
    }

    @Override
    public void handleResponse(InetSocketAddress responseFrom, Transport transport, byte version, byte command, int payloadSize, ByteBuffer payloadBuffer) {
        InetAddress addr;
        long timestamp = System.currentTimeMillis();
        super.handleResponse(responseFrom, transport, version, command, payloadSize, payloadBuffer);
        transport.ensureData(34);
        byte[] guid = new byte[12];
        payloadBuffer.get(guid);
        payloadBuffer.get();
        int sequentalID = payloadBuffer.get() & 0xFF;
        int changeCount = payloadBuffer.getShort() & 0xFFFF;
        byte[] byteAddress = new byte[16];
        payloadBuffer.get(byteAddress);
        int port = payloadBuffer.getShort() & 0xFFFF;
        try {
            addr = InetAddress.getByAddress(byteAddress);
        }
        catch (UnknownHostException e) {
            this.context.getLogger().log(Level.FINER, "Invalid address '" + new String(byteAddress) + "' in beacon received from: " + responseFrom, e);
            return;
        }
        responseFrom = !addr.isAnyLocalAddress() ? new InetSocketAddress(addr, port) : new InetSocketAddress(responseFrom.getAddress(), port);
        String protocol = SerializeHelper.deserializeString((ByteBuffer)payloadBuffer, (DeserializableControl)transport);
        org.epics.pvaccess.client.impl.remote.BeaconHandler beaconHandler = this.context.getBeaconHandler(protocol, responseFrom);
        if (beaconHandler == null) {
            return;
        }
        PVField data = null;
        Field field = fieldCreate.deserialize(payloadBuffer, (DeserializableControl)transport);
        if (field != null) {
            data = pvDataCreate.createPVField(field);
            data.deserialize(payloadBuffer, (DeserializableControl)transport);
        }
        beaconHandler.beaconNotify(responseFrom, version, timestamp, guid, sequentalID, changeCount, data);
    }
}

