/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.client.impl.remote.handlers;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.epics.pvaccess.client.impl.remote.ClientContextImpl;
import org.epics.pvaccess.client.impl.remote.handlers.AbstractClientResponseHandler;
import org.epics.pvaccess.impl.remote.Transport;
import org.epics.pvaccess.util.HexDump;

public class BadResponse
extends AbstractClientResponseHandler {
    public BadResponse(ClientContextImpl context) {
        super(context, "Bad response");
    }

    @Override
    public void handleResponse(InetSocketAddress responseFrom, Transport transport, byte version, byte command, int payloadSize, ByteBuffer payloadBuffer) {
        super.handleResponse(responseFrom, transport, version, command, payloadSize, payloadBuffer);
        this.context.getLogger().severe("Undecipherable message (bad response type " + command + ") from " + responseFrom + ".");
        if (payloadBuffer.hasArray()) {
            int start = Math.max(0, payloadBuffer.position() - 8);
            HexDump.hexDump(this.description, payloadBuffer.array(), start, payloadBuffer.limit());
        }
    }
}

