/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.client.impl.remote;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.epics.pvaccess.PVAException;
import org.epics.pvaccess.PVFactory;
import org.epics.pvaccess.client.AccessRights;
import org.epics.pvaccess.client.Channel;
import org.epics.pvaccess.client.ChannelArray;
import org.epics.pvaccess.client.ChannelArrayRequester;
import org.epics.pvaccess.client.ChannelGet;
import org.epics.pvaccess.client.ChannelGetRequester;
import org.epics.pvaccess.client.ChannelProcess;
import org.epics.pvaccess.client.ChannelProcessRequester;
import org.epics.pvaccess.client.ChannelProvider;
import org.epics.pvaccess.client.ChannelPut;
import org.epics.pvaccess.client.ChannelPutGet;
import org.epics.pvaccess.client.ChannelPutGetRequester;
import org.epics.pvaccess.client.ChannelPutRequester;
import org.epics.pvaccess.client.ChannelRPC;
import org.epics.pvaccess.client.ChannelRPCRequester;
import org.epics.pvaccess.client.ChannelRequester;
import org.epics.pvaccess.client.GetFieldRequester;
import org.epics.pvaccess.client.impl.remote.ChannelArrayRequestImpl;
import org.epics.pvaccess.client.impl.remote.ChannelGetFieldRequestImpl;
import org.epics.pvaccess.client.impl.remote.ChannelGetRequestImpl;
import org.epics.pvaccess.client.impl.remote.ChannelMonitorImpl;
import org.epics.pvaccess.client.impl.remote.ChannelProcessRequestImpl;
import org.epics.pvaccess.client.impl.remote.ChannelPutGetRequestImpl;
import org.epics.pvaccess.client.impl.remote.ChannelPutRequestImpl;
import org.epics.pvaccess.client.impl.remote.ChannelRPCRequestImpl;
import org.epics.pvaccess.client.impl.remote.ClientContextImpl;
import org.epics.pvaccess.client.impl.remote.search.SearchInstance;
import org.epics.pvaccess.impl.remote.Transport;
import org.epics.pvaccess.impl.remote.TransportClient;
import org.epics.pvaccess.impl.remote.TransportSendControl;
import org.epics.pvaccess.impl.remote.TransportSender;
import org.epics.pvaccess.impl.remote.request.ResponseRequest;
import org.epics.pvaccess.impl.remote.request.SubscriptionRequest;
import org.epics.pvaccess.impl.remote.utils.GUID;
import org.epics.pvdata.misc.SerializeHelper;
import org.epics.pvdata.misc.Timer;
import org.epics.pvdata.misc.TimerFactory;
import org.epics.pvdata.monitor.Monitor;
import org.epics.pvdata.monitor.MonitorRequester;
import org.epics.pvdata.pv.MessageType;
import org.epics.pvdata.pv.PVField;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.SerializableControl;
import org.epics.pvdata.pv.Status;
import org.epics.pvdata.pv.StatusCreate;

public class ChannelImpl
implements Channel,
SearchInstance,
TransportClient,
TransportSender,
Timer.TimerCallback {
    protected final int channelID;
    protected final String name;
    protected final ClientContextImpl context;
    protected final short priority;
    protected final InetSocketAddress[] addresses;
    protected Channel.ConnectionState connectionState = Channel.ConnectionState.NEVER_CONNECTED;
    protected final ChannelRequester requester;
    protected final Map<Integer, ResponseRequest> responseRequests = new HashMap<Integer, ResponseRequest>();
    protected boolean allowCreation = true;
    protected int references = 1;
    protected Transport transport = null;
    protected int serverChannelID = -1;
    private final AtomicInteger userValue = new AtomicInteger();
    private GUID serverGUID = null;
    private int addressIndex = 0;
    private final Timer.TimerNode timerNode = TimerFactory.createNode((Timer.TimerCallback)this);
    private static final int STATIC_SEARCH_BASE_DELAY_SEC = 5;
    private static final int STATIC_SEARCH_MAX_MULTIPLIER = 10;
    private static final GUID dummyGUID = new GUID(new byte[12]);
    private boolean needSubscriptionUpdate = false;
    private static final StatusCreate statusCreate = PVFactory.getStatusCreate();
    public static final Status channelDestroyed = statusCreate.createStatus(Status.StatusType.WARNING, "channel destroyed", null);
    public static final Status channelDisconnected = statusCreate.createStatus(Status.StatusType.WARNING, "channel disconnected", null);
    private volatile boolean issueCreateMessage = true;

    protected ChannelImpl(ClientContextImpl context, int channelID, String name, ChannelRequester requester, short priority, InetSocketAddress[] addresses) throws PVAException {
        this.context = context;
        this.channelID = channelID;
        this.name = name;
        this.priority = priority;
        this.addresses = addresses;
        this.requester = requester;
        context.registerChannel(this);
        this.connect();
    }

    public synchronized void createChannel(Transport transport) {
        if (!this.allowCreation) {
            return;
        }
        this.allowCreation = false;
        if (this.transport != null && this.transport != transport) {
            this.disconnectPendingIO(false);
            this.transport.release(this);
        } else if (this.transport == transport) {
            return;
        }
        this.transport = transport;
        this.transport.enqueueSendRequest(this);
    }

    public void cancel() {
    }

    public void timeout() {
        this.createChannelFailed();
    }

    public synchronized void createChannelFailed() {
        this.cancel();
        if (this.transport != null) {
            this.transport.release(this);
            this.transport = null;
        }
        this.initiateSearch(true);
    }

    public synchronized void connectionCompleted(int sid) throws IllegalStateException {
        try {
            if (this.connectionState == Channel.ConnectionState.DESTROYED) {
                return;
            }
            this.serverChannelID = sid;
            this.addressIndex = 0;
            this.resubscribeSubscriptions();
            this.setConnectionState(Channel.ConnectionState.CONNECTED);
        }
        finally {
            this.cancel();
        }
    }

    public void channelDestroyedOnServer() {
        this.disconnect(true, false);
    }

    public synchronized void destroy(boolean force) throws PVAException, IllegalStateException {
        if (this.connectionState == Channel.ConnectionState.DESTROYED) {
            throw new IllegalStateException("Channel already destroyed.");
        }
        this.context.destroyChannel(this, force);
    }

    public synchronized void acquire() {
        ++this.references;
    }

    public synchronized void destroyChannel(boolean force) throws PVAException, IllegalStateException, IOException {
        if (this.connectionState == Channel.ConnectionState.DESTROYED) {
            throw new IllegalStateException("Channel already destroyed.");
        }
        --this.references;
        if (this.references > 0 && !force) {
            return;
        }
        this.context.getChannelSearchManager().unregister(this);
        this.cancel();
        this.disconnectPendingIO(true);
        if (this.connectionState == Channel.ConnectionState.CONNECTED) {
            this.disconnect(false, true);
        } else if (this.transport != null) {
            this.transport.release(this);
            this.transport = null;
        }
        this.setConnectionState(Channel.ConnectionState.DESTROYED);
        this.context.unregisterChannel(this);
    }

    public synchronized void disconnect(boolean initiateSearch, boolean remoteDestroy) {
        if (this.connectionState != Channel.ConnectionState.CONNECTED) {
            return;
        }
        if (!initiateSearch) {
            this.context.getChannelSearchManager().unregister(this);
            this.cancel();
        }
        this.setConnectionState(Channel.ConnectionState.DISCONNECTED);
        this.disconnectPendingIO(false);
        if (this.transport != null) {
            if (remoteDestroy) {
                this.issueCreateMessage = false;
                this.transport.enqueueSendRequest(this);
            }
            this.transport.release(this);
            this.transport = null;
        }
        if (initiateSearch) {
            this.initiateSearch(false);
        }
    }

    public synchronized void initiateSearch(boolean penalize) {
        this.allowCreation = true;
        if (this.addresses == null) {
            this.context.getChannelSearchManager().register(this, penalize);
        } else {
            this.context.getTimer().scheduleAfterDelay(this.timerNode, (double)(this.addressIndex / this.addresses.length * 5));
        }
    }

    public void callback() {
        int ix = this.addressIndex % this.addresses.length;
        ++this.addressIndex;
        if (this.addressIndex >= this.addresses.length * 11) {
            this.addressIndex = this.addresses.length * 10;
        }
        this.searchResponse(dummyGUID, (byte)1, this.addresses[ix]);
    }

    public void timerStopped() {
    }

    @Override
    public AtomicInteger getUserValue() {
        return this.userValue;
    }

    @Override
    public synchronized void searchResponse(GUID guid, byte minorRevision, InetSocketAddress serverAddress) {
        Transport transport = this.getTransport();
        if (transport != null && !transport.getRemoteAddress().equals(serverAddress) && !guid.equals(this.serverGUID)) {
            this.requester.message("More than one channel with name '" + this.name + "' detected, connected to: " + transport.getRemoteAddress() + ", ignored: " + serverAddress, MessageType.warning);
            return;
        }
        transport = this.context.getTransport(this, serverAddress, minorRevision, this.priority);
        if (transport == null) {
            this.createChannelFailed();
            return;
        }
        this.serverGUID = guid;
        this.createChannel(transport);
    }

    @Override
    public void transportClosed() {
        this.disconnect(true, false);
    }

    @Override
    public void transportChanged() {
    }

    @Override
    public synchronized void transportResponsive(Transport transport) {
        if (this.connectionState == Channel.ConnectionState.DISCONNECTED) {
            this.updateSubscriptions();
            this.connectionCompleted(this.serverChannelID);
        }
    }

    @Override
    public synchronized void transportUnresponsive() {
    }

    private synchronized void setConnectionState(Channel.ConnectionState connectionState) {
        if (this.connectionState != connectionState) {
            this.connectionState = connectionState;
            try {
                this.requester.channelStateChange(this, connectionState);
            }
            catch (Throwable th) {
                StringWriter writer = new StringWriter();
                PrintWriter printWriter = new PrintWriter(writer);
                th.printStackTrace(printWriter);
                this.requester.message("Unexpected exception caught: " + writer, MessageType.fatalError);
            }
        }
    }

    @Override
    public synchronized Channel.ConnectionState getConnectionState() {
        return this.connectionState;
    }

    @Override
    public synchronized String getRemoteAddress() {
        if (this.connectionState != Channel.ConnectionState.CONNECTED) {
            return null;
        }
        return this.transport.getRemoteAddress().toString();
    }

    @Override
    public int getChannelID() {
        return this.channelID;
    }

    public ClientContextImpl getContext() {
        return this.context;
    }

    public final synchronized Transport checkAndGetTransport() {
        if (this.connectionState == Channel.ConnectionState.DESTROYED) {
            throw new IllegalStateException("Channel destroyed.");
        }
        if (this.connectionState != Channel.ConnectionState.CONNECTED) {
            throw new IllegalStateException("Channel not connected.");
        }
        return this.transport;
    }

    public final synchronized Transport checkDestroyedAndGetTransport() {
        if (this.connectionState == Channel.ConnectionState.DESTROYED) {
            throw new IllegalStateException("Channel destroyed.");
        }
        if (this.connectionState == Channel.ConnectionState.CONNECTED) {
            return this.transport;
        }
        return null;
    }

    public synchronized Transport getTransport() {
        return this.transport;
    }

    public synchronized int getServerChannelID() {
        return this.serverChannelID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerResponseRequest(ResponseRequest responseRequest) {
        Map<Integer, ResponseRequest> map = this.responseRequests;
        synchronized (map) {
            this.responseRequests.put(responseRequest.getIOID(), responseRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterResponseRequest(ResponseRequest responseRequest) {
        Map<Integer, ResponseRequest> map = this.responseRequests;
        synchronized (map) {
            this.responseRequests.remove(responseRequest.getIOID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectPendingIO(boolean destroy) {
        Status status = destroy ? channelDestroyed : channelDisconnected;
        Map<Integer, ResponseRequest> map = this.responseRequests;
        synchronized (map) {
            this.needSubscriptionUpdate = true;
            ResponseRequest[] rrs = new ResponseRequest[this.responseRequests.size()];
            this.responseRequests.values().toArray(rrs);
            for (int i = 0; i < rrs.length; ++i) {
                try {
                    rrs[i].reportStatus(status);
                    continue;
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resubscribeSubscriptions() {
        Map<Integer, ResponseRequest> map = this.responseRequests;
        synchronized (map) {
            Transport transport = this.getTransport();
            ResponseRequest[] rrs = new ResponseRequest[this.responseRequests.size()];
            this.responseRequests.values().toArray(rrs);
            for (int i = 0; i < rrs.length; ++i) {
                try {
                    if (!(rrs[i] instanceof SubscriptionRequest)) continue;
                    ((SubscriptionRequest)rrs[i]).resubscribeSubscription(transport);
                    continue;
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSubscriptions() {
        Map<Integer, ResponseRequest> map = this.responseRequests;
        synchronized (map) {
            if (!this.needSubscriptionUpdate) {
                return;
            }
            this.needSubscriptionUpdate = false;
            ResponseRequest[] rrs = new ResponseRequest[this.responseRequests.size()];
            this.responseRequests.values().toArray(rrs);
            for (int i = 0; i < rrs.length; ++i) {
                try {
                    if (!(rrs[i] instanceof SubscriptionRequest)) continue;
                    ((SubscriptionRequest)rrs[i]).updateSubscription();
                    continue;
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
        }
    }

    public short getPriority() {
        return this.priority;
    }

    public synchronized String toString() {
        StringBuilder buffy = new StringBuilder();
        buffy.append("CHANNEL  : ").append(this.name).append('\n');
        buffy.append("STATE    : ").append((Object)this.connectionState).append('\n');
        if (this.connectionState == Channel.ConnectionState.CONNECTED) {
            buffy.append("ADDRESS  : ").append(this.getRemoteAddress()).append('\n');
        }
        return buffy.toString();
    }

    protected final synchronized void connect() {
        if (this.connectionState == Channel.ConnectionState.DESTROYED) {
            throw new IllegalArgumentException("Channel destroyed.");
        }
        if (this.connectionState != Channel.ConnectionState.CONNECTED) {
            this.initiateSearch(false);
        }
    }

    protected synchronized void disconnect() {
        if (this.connectionState == Channel.ConnectionState.DESTROYED) {
            throw new IllegalArgumentException("Channel destroyed.");
        }
        if (this.connectionState == Channel.ConnectionState.CONNECTED) {
            this.disconnect(false, true);
        }
    }

    @Override
    public ChannelGet createChannelGet(ChannelGetRequester channelGetRequester, PVStructure pvRequest) {
        return ChannelGetRequestImpl.create(this, channelGetRequester, pvRequest);
    }

    @Override
    public Monitor createMonitor(MonitorRequester monitorRequester, PVStructure pvRequest) {
        return ChannelMonitorImpl.create(this, monitorRequester, pvRequest);
    }

    @Override
    public ChannelProcess createChannelProcess(ChannelProcessRequester channelProcessRequester, PVStructure pvRequest) {
        return ChannelProcessRequestImpl.create(this, channelProcessRequester, pvRequest);
    }

    @Override
    public ChannelPut createChannelPut(ChannelPutRequester channelPutRequester, PVStructure pvRequest) {
        return ChannelPutRequestImpl.create(this, channelPutRequester, pvRequest);
    }

    @Override
    public ChannelPutGet createChannelPutGet(ChannelPutGetRequester channelPutGetRequester, PVStructure pvRequest) {
        return ChannelPutGetRequestImpl.create(this, channelPutGetRequester, pvRequest);
    }

    @Override
    public ChannelRPC createChannelRPC(ChannelRPCRequester channelRPCRequester, PVStructure pvRequest) {
        return ChannelRPCRequestImpl.create(this, channelRPCRequester, pvRequest);
    }

    @Override
    public AccessRights getAccessRights(PVField pvField) {
        return AccessRights.readWrite;
    }

    @Override
    public String getChannelName() {
        return this.name;
    }

    @Override
    public ChannelRequester getChannelRequester() {
        return this.requester;
    }

    @Override
    public ChannelProvider getProvider() {
        return this.context.getProvider();
    }

    @Override
    public synchronized boolean isConnected() {
        return this.connectionState == Channel.ConnectionState.CONNECTED;
    }

    public String getRequesterName() {
        return this.requester.getRequesterName();
    }

    public void message(String message, MessageType messageType) {
        System.err.println("[" + messageType + "] " + message);
    }

    @Override
    public void destroy() {
        try {
            this.destroy(false);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Throwable th) {
            throw new RuntimeException("Failed to destroy channel.", th);
        }
    }

    @Override
    public ChannelArray createChannelArray(ChannelArrayRequester channelArrayRequester, PVStructure pvRequest) {
        return ChannelArrayRequestImpl.create(this, channelArrayRequester, pvRequest);
    }

    @Override
    public void getField(GetFieldRequester requester, String subField) {
        ChannelGetFieldRequestImpl.create(this, requester, subField);
    }

    @Override
    public void lock() {
    }

    @Override
    public void send(ByteBuffer buffer, TransportSendControl control) {
        if (this.issueCreateMessage) {
            control.startMessage((byte)7, 6);
            buffer.putShort((short)1);
            buffer.putInt(this.channelID);
            SerializeHelper.serializeString((String)this.name, (ByteBuffer)buffer, (SerializableControl)control);
            control.flush(true);
        } else {
            control.startMessage((byte)8, 8);
            buffer.putInt(this.getServerChannelID());
            buffer.putInt(this.channelID);
            control.flush(true);
        }
    }

    @Override
    public void unlock() {
    }
}

