/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.client.impl.remote;

import java.nio.ByteBuffer;
import org.epics.pvaccess.PVFactory;
import org.epics.pvaccess.client.GetFieldRequester;
import org.epics.pvaccess.client.impl.remote.BaseRequestImpl;
import org.epics.pvaccess.client.impl.remote.ChannelImpl;
import org.epics.pvaccess.client.impl.remote.ClientContextImpl;
import org.epics.pvaccess.impl.remote.Transport;
import org.epics.pvaccess.impl.remote.TransportSendControl;
import org.epics.pvaccess.impl.remote.TransportSender;
import org.epics.pvaccess.impl.remote.request.DataResponse;
import org.epics.pvdata.misc.SerializeHelper;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.Field;
import org.epics.pvdata.pv.Requester;
import org.epics.pvdata.pv.SerializableControl;
import org.epics.pvdata.pv.Status;
import org.epics.pvdata.pv.StatusCreate;

public class ChannelGetFieldRequestImpl
implements DataResponse,
TransportSender {
    private static final StatusCreate statusCreate = PVFactory.getStatusCreate();
    protected final ChannelImpl channel;
    protected final ClientContextImpl context;
    protected final int ioid;
    protected final GetFieldRequester callback;
    protected final String subField;
    protected volatile boolean destroyed = false;

    public static ChannelGetFieldRequestImpl create(ChannelImpl channel, GetFieldRequester callback, String subField) {
        ChannelGetFieldRequestImpl thisInstance = new ChannelGetFieldRequestImpl(channel, callback, subField);
        thisInstance.activate();
        return thisInstance;
    }

    protected ChannelGetFieldRequestImpl(ChannelImpl channel, GetFieldRequester callback, String subField) {
        if (callback == null) {
            throw new IllegalArgumentException("null requester");
        }
        this.channel = channel;
        this.context = channel.getContext();
        this.callback = callback;
        this.subField = subField;
        this.ioid = this.context.registerResponseRequest(this);
    }

    protected void activate() {
        this.channel.registerResponseRequest(this);
        try {
            this.channel.checkAndGetTransport().enqueueSendRequest(this);
        }
        catch (IllegalStateException ise) {
            this.callback.getDone(BaseRequestImpl.channelNotConnected, null);
        }
    }

    @Override
    public void lock() {
    }

    @Override
    public void send(ByteBuffer buffer, TransportSendControl control) {
        control.startMessage((byte)17, 8);
        buffer.putInt(this.channel.getServerChannelID());
        buffer.putInt(this.ioid);
        SerializeHelper.serializeString((String)this.subField, (ByteBuffer)buffer, (SerializableControl)control);
    }

    @Override
    public void unlock() {
    }

    @Override
    public int getIOID() {
        return this.ioid;
    }

    @Override
    public Requester getRequester() {
        return this.callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void response(Transport transport, byte version, ByteBuffer payloadBuffer) {
        try {
            Status status = statusCreate.deserializeStatus(payloadBuffer, (DeserializableControl)transport);
            if (status.isSuccess()) {
                Field field = transport.cachedDeserialize(payloadBuffer);
                this.callback.getDone(status, field);
            } else {
                this.callback.getDone(status, null);
            }
        }
        finally {
            this.destroy();
        }
    }

    @Override
    public void cancel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        ChannelGetFieldRequestImpl channelGetFieldRequestImpl = this;
        synchronized (channelGetFieldRequestImpl) {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
        }
        this.context.unregisterResponseRequest(this);
        this.channel.unregisterResponseRequest(this);
    }

    @Override
    public void timeout() {
        this.cancel();
    }

    @Override
    public void reportStatus(Status status) {
        if (status == ChannelImpl.channelDestroyed) {
            this.destroy();
        }
    }
}

