/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.client.impl.remote;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import org.epics.pvaccess.client.ChannelArray;
import org.epics.pvaccess.client.ChannelArrayRequester;
import org.epics.pvaccess.client.impl.remote.BaseRequestImpl;
import org.epics.pvaccess.client.impl.remote.ChannelImpl;
import org.epics.pvaccess.impl.remote.QoS;
import org.epics.pvaccess.impl.remote.SerializationHelper;
import org.epics.pvaccess.impl.remote.Transport;
import org.epics.pvaccess.impl.remote.TransportSendControl;
import org.epics.pvdata.misc.SerializeHelper;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.Field;
import org.epics.pvdata.pv.MessageType;
import org.epics.pvdata.pv.PVArray;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.SerializableControl;
import org.epics.pvdata.pv.Status;

public class ChannelArrayRequestImpl
extends BaseRequestImpl
implements ChannelArray {
    protected final ChannelArrayRequester callback;
    protected PVArray data;
    protected PVArray putData;
    protected int offset = 0;
    protected int count = 0;
    protected int stride = 0;
    protected int length = 0;

    public static ChannelArrayRequestImpl create(ChannelImpl channel, ChannelArrayRequester callback, PVStructure pvRequest) {
        ChannelArrayRequestImpl thisInstance = new ChannelArrayRequestImpl(channel, callback, pvRequest);
        thisInstance.activate();
        return thisInstance;
    }

    protected ChannelArrayRequestImpl(ChannelImpl channel, ChannelArrayRequester callback, PVStructure pvRequest) {
        super(channel, callback, pvRequest, false);
        this.callback = callback;
    }

    @Override
    protected void activate() {
        super.activate();
        try {
            this.resubscribeSubscription(this.channel.checkDestroyedAndGetTransport());
        }
        catch (IllegalStateException ise) {
            this.callback.channelArrayConnect(channelDestroyed, this, null);
            this.destroy(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(ByteBuffer buffer, TransportSendControl control) {
        int pendingRequest = this.getPendingRequest();
        if (pendingRequest < 0) {
            super.send(buffer, control);
            return;
        }
        control.startMessage((byte)14, 9);
        buffer.putInt(this.channel.getServerChannelID());
        buffer.putInt(this.ioid);
        buffer.put((byte)pendingRequest);
        if (QoS.INIT.isSet(pendingRequest)) {
            SerializationHelper.serializePVRequest(buffer, control, this.pvRequest);
        } else {
            if (QoS.GET.isSet(pendingRequest)) {
                this.lock();
                try {
                    SerializeHelper.writeSize((int)this.offset, (ByteBuffer)buffer, (SerializableControl)control);
                    SerializeHelper.writeSize((int)this.count, (ByteBuffer)buffer, (SerializableControl)control);
                    SerializeHelper.writeSize((int)this.stride, (ByteBuffer)buffer, (SerializableControl)control);
                }
                finally {
                    this.unlock();
                }
            }
            if (QoS.GET_PUT.isSet(pendingRequest)) {
                this.lock();
                try {
                    SerializeHelper.writeSize((int)this.length, (ByteBuffer)buffer, (SerializableControl)control);
                }
                finally {
                    this.unlock();
                }
            }
            if (!QoS.PROCESS.isSet(pendingRequest)) {
                this.lock();
                try {
                    SerializeHelper.writeSize((int)this.offset, (ByteBuffer)buffer, (SerializableControl)control);
                    SerializeHelper.writeSize((int)this.stride, (ByteBuffer)buffer, (SerializableControl)control);
                    this.putData.serialize(buffer, (SerializableControl)control, 0, this.count != 0 ? this.count : this.putData.getLength());
                }
                finally {
                    this.putData = null;
                    this.unlock();
                }
            }
        }
        this.stopRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void initResponse(Transport transport, byte version, ByteBuffer payloadBuffer, byte qos, Status status) {
        try {
            if (!status.isSuccess()) {
                this.callback.channelArrayConnect(status, this, null);
                return;
            }
            Field field = transport.cachedDeserialize(payloadBuffer);
            this.lock();
            try {
                this.data = (PVArray)pvDataCreate.createPVField(field);
            }
            finally {
                this.unlock();
            }
            this.callback.channelArrayConnect(status, this, this.data.getArray());
        }
        catch (Throwable th) {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            th.printStackTrace(printWriter);
            this.requester.message("Unexpected exception caught: " + writer, MessageType.fatalError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void normalResponse(Transport transport, byte version, ByteBuffer payloadBuffer, byte qos, Status status) {
        block12: {
            try {
                if (QoS.GET.isSet(qos)) {
                    if (!status.isSuccess()) {
                        this.callback.getArrayDone(status, this, null);
                        return;
                    }
                    this.lock();
                    try {
                        this.data.deserialize(payloadBuffer, (DeserializableControl)transport);
                    }
                    finally {
                        this.unlock();
                    }
                    this.callback.getArrayDone(okStatus, this, this.data);
                    break block12;
                }
                if (QoS.GET_PUT.isSet(qos)) {
                    this.callback.setLengthDone(status, this);
                } else if (QoS.PROCESS.isSet(qos)) {
                    int length = SerializeHelper.readSize((ByteBuffer)payloadBuffer, (DeserializableControl)transport);
                    this.callback.getLengthDone(status, this, length);
                } else {
                    this.callback.putArrayDone(status, this);
                }
            }
            catch (Throwable th) {
                StringWriter writer = new StringWriter();
                PrintWriter printWriter = new PrintWriter(writer);
                th.printStackTrace(printWriter);
                this.requester.message("Unexpected exception caught: " + writer, MessageType.fatalError);
            }
        }
    }

    @Override
    public void getArray(int offset, int count, int stride) {
        if (offset < 0) {
            throw new IllegalArgumentException("offset < 0");
        }
        if (count < 0) {
            throw new IllegalArgumentException("count < 0");
        }
        if (stride <= 0) {
            throw new IllegalArgumentException("stride <= 0");
        }
        if (this.destroyed) {
            this.callback.getArrayDone(destroyedStatus, this, null);
            return;
        }
        if (!this.startRequest(this.lastRequest ? QoS.DESTROY.getMaskValue() | QoS.GET.getMaskValue() : QoS.GET.getMaskValue())) {
            this.callback.getArrayDone(otherRequestPendingStatus, this, null);
            return;
        }
        try {
            this.lock();
            this.offset = offset;
            this.count = count;
            this.stride = stride;
            this.unlock();
            this.channel.checkAndGetTransport().enqueueSendRequest(this);
        }
        catch (IllegalStateException ise) {
            this.stopRequest();
            this.callback.getArrayDone(channelNotConnected, this, null);
        }
    }

    @Override
    public void putArray(PVArray putArray, int offset, int count, int stride) {
        if (offset < 0) {
            throw new IllegalArgumentException("offset < 0");
        }
        if (count < 0) {
            throw new IllegalArgumentException("count < 0");
        }
        if (stride <= 0) {
            throw new IllegalArgumentException("stride <= 0");
        }
        if (this.destroyed) {
            this.callback.putArrayDone(destroyedStatus, this);
            return;
        }
        if (!putArray.getArray().equals(this.data.getArray())) {
            this.callback.putArrayDone(invalidPutArrayStatus, this);
            return;
        }
        if (!this.startRequest(this.lastRequest ? QoS.DESTROY.getMaskValue() : QoS.DEFAULT.getMaskValue())) {
            this.callback.putArrayDone(otherRequestPendingStatus, this);
            return;
        }
        try {
            this.lock();
            this.putData = putArray;
            this.offset = offset;
            this.count = count;
            this.stride = stride;
            this.unlock();
            this.channel.checkAndGetTransport().enqueueSendRequest(this);
        }
        catch (IllegalStateException ise) {
            this.stopRequest();
            this.callback.putArrayDone(channelNotConnected, this);
        }
    }

    @Override
    public void setLength(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        if (this.destroyed) {
            this.callback.putArrayDone(destroyedStatus, this);
            return;
        }
        if (!this.startRequest(this.lastRequest ? QoS.DESTROY.getMaskValue() | QoS.GET_PUT.getMaskValue() : QoS.GET_PUT.getMaskValue())) {
            this.callback.setLengthDone(otherRequestPendingStatus, this);
            return;
        }
        try {
            this.lock();
            this.length = length;
            this.unlock();
            this.channel.checkAndGetTransport().enqueueSendRequest(this);
        }
        catch (IllegalStateException ise) {
            this.stopRequest();
            this.callback.setLengthDone(channelNotConnected, this);
        }
    }

    @Override
    public void getLength() {
        if (this.destroyed) {
            this.callback.getLengthDone(destroyedStatus, this, 0);
            return;
        }
        if (!this.startRequest(this.lastRequest ? QoS.DESTROY.getMaskValue() | QoS.PROCESS.getMaskValue() : QoS.PROCESS.getMaskValue())) {
            this.callback.getLengthDone(otherRequestPendingStatus, this, 0);
            return;
        }
        try {
            this.channel.checkAndGetTransport().enqueueSendRequest(this);
        }
        catch (IllegalStateException ise) {
            this.stopRequest();
            this.callback.getLengthDone(channelNotConnected, this, 0);
        }
    }
}

