/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca;

import gov.aps.jca.CAException;
import gov.aps.jca.Context;
import gov.aps.jca.JCALibrary;
import gov.aps.jca.event.ContextExceptionEvent;
import gov.aps.jca.event.ContextExceptionListener;
import gov.aps.jca.event.ContextMessageEvent;
import gov.aps.jca.event.ContextMessageListener;
import gov.aps.jca.event.ContextVirtualCircuitExceptionEvent;
import org.epics.ca.BaseV3Channel;
import org.epics.pvaccess.client.Channel;
import org.epics.pvaccess.client.ChannelFind;
import org.epics.pvaccess.client.ChannelFindRequester;
import org.epics.pvaccess.client.ChannelListRequester;
import org.epics.pvaccess.client.ChannelProvider;
import org.epics.pvaccess.client.ChannelProviderFactory;
import org.epics.pvaccess.client.ChannelProviderRegistryFactory;
import org.epics.pvaccess.client.ChannelRequester;
import org.epics.pvdata.factory.StatusFactory;
import org.epics.pvdata.misc.RunnableReady;
import org.epics.pvdata.misc.ThreadCreate;
import org.epics.pvdata.misc.ThreadCreateFactory;
import org.epics.pvdata.misc.ThreadPriority;
import org.epics.pvdata.misc.ThreadReady;
import org.epics.pvdata.pv.Status;

public class ClientFactory {
    private static ChannelProviderImpl channelProvider = null;
    private static final ThreadCreate threadCreate = ThreadCreateFactory.getThreadCreate();
    private static ChannelProviderFactoryImpl factory = null;
    public static final String PROVIDER_NAME = "ca";
    public static final String JCA_CONTEXT_CLASS_PROPERTY_NAME = ClientFactory.class.getName() + ".jcaContextClass";

    public static synchronized void start() {
        if (factory != null) {
            return;
        }
        factory = new ChannelProviderFactoryImpl();
        ChannelProviderRegistryFactory.registerChannelProviderFactory(factory);
    }

    public static synchronized void stop() {
        if (factory != null) {
            ChannelProviderRegistryFactory.unregisterChannelProviderFactory(factory);
            if (factory.destroySharedInstance()) {
                factory = null;
            }
        }
    }

    private static class CAThread
    implements RunnableReady {
        private final Thread thread;
        private final Context context;

        private CAThread(String threadName, int threadPriority, Context context) {
            this.context = context;
            this.thread = threadCreate.create(threadName, threadPriority, (RunnableReady)this);
        }

        public void run(ThreadReady threadReady) {
            threadReady.ready();
            try {
                while (true) {
                    try {
                        this.context.poll();
                    }
                    catch (CAException e) {
                        System.out.println(e.getMessage());
                        break;
                    }
                    Thread.sleep(5L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private void stop() {
            this.thread.interrupt();
        }
    }

    private static class LocateFind
    implements ChannelFind,
    ChannelFindRequester {
        private final ChannelProvider channelProvider;
        private volatile ChannelFindRequester channelFindRequester = null;
        private volatile BaseV3Channel v3Channel = null;
        private final String channelName;
        private final Context context;

        LocateFind(ChannelProvider channelProvider, String channelName, Context context) {
            this.channelProvider = channelProvider;
            this.channelName = channelName;
            this.context = context;
        }

        void find(ChannelFindRequester channelFindRequester) {
            this.channelFindRequester = channelFindRequester;
            this.v3Channel = new BaseV3Channel(this.channelProvider, this, null, this.context, this.channelName);
            this.v3Channel.connectCaV3();
        }

        Channel create(ChannelRequester channelRequester) {
            this.v3Channel = new BaseV3Channel(this.channelProvider, null, channelRequester, this.context, this.channelName);
            this.v3Channel.connectCaV3();
            return this.v3Channel;
        }

        @Override
        public void cancel() {
            this.v3Channel.destroy();
        }

        @Override
        public ChannelProvider getChannelProvider() {
            return this.channelProvider;
        }

        @Override
        public void channelFindResult(Status status, ChannelFind channelFind, boolean wasFound) {
            this.channelFindRequester.channelFindResult(status, channelFind, wasFound);
            this.v3Channel.destroy();
        }
    }

    private static class ChannelProviderImpl
    implements ChannelProvider,
    ContextExceptionListener,
    ContextMessageListener {
        private final Context context;
        private final CAThread caThread;
        private static final Status listNotSupported = StatusFactory.getStatusCreate().createStatus(Status.StatusType.ERROR, "channelList not supported", null);
        private ChannelFind channelFind = new ChannelFind(){

            @Override
            public ChannelProvider getChannelProvider() {
                return this;
            }

            @Override
            public void cancel() {
            }
        };

        ChannelProviderImpl() {
            CAThread t;
            Context c = null;
            try {
                String contextClass = System.getProperty(JCA_CONTEXT_CLASS_PROPERTY_NAME, "com.cosylab.epics.caj.CAJContext");
                c = JCALibrary.getInstance().createContext(contextClass);
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.context = null;
                this.caThread = null;
                return;
            }
            this.context = c;
            try {
                this.context.addContextExceptionListener((ContextExceptionListener)this);
                this.context.addContextMessageListener((ContextMessageListener)this);
                t = new CAThread(ClientFactory.PROVIDER_NAME, ThreadPriority.getJavaPriority((ThreadPriority)ThreadPriority.low), this.context);
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.caThread = null;
                return;
            }
            this.caThread = t;
        }

        @Override
        public void destroy() {
            this.caThread.stop();
            try {
                this.context.destroy();
            }
            catch (CAException e) {
                e.printStackTrace();
            }
        }

        @Override
        public ChannelFind channelFind(String channelName, ChannelFindRequester channelFindRequester) {
            LocateFind locateFind = new LocateFind(this, channelName, this.context);
            locateFind.find(channelFindRequester);
            return locateFind;
        }

        @Override
        public ChannelFind channelList(ChannelListRequester channelListRequester) {
            channelListRequester.channelListResult(listNotSupported, this.channelFind, null, false);
            return this.channelFind;
        }

        @Override
        public Channel createChannel(String channelName, ChannelRequester channelRequester, short priority) {
            LocateFind locateFind = new LocateFind(this, channelName, this.context);
            return locateFind.create(channelRequester);
        }

        @Override
        public Channel createChannel(String channelName, ChannelRequester channelRequester, short priority, String address) {
            if (address != null) {
                throw new IllegalArgumentException("address not allowed for CA implementation");
            }
            return this.createChannel(channelName, channelRequester, priority);
        }

        @Override
        public String getProviderName() {
            return ClientFactory.PROVIDER_NAME;
        }

        public void contextException(ContextExceptionEvent arg0) {
            String message = arg0.getMessage();
            System.err.println(message);
            System.err.flush();
        }

        public void contextVirtualCircuitException(ContextVirtualCircuitExceptionEvent arg0) {
            String message = "status " + arg0.getStatus().toString();
            System.err.println(message);
            System.err.flush();
        }

        public void contextMessage(ContextMessageEvent arg0) {
            String message = arg0.getMessage();
            System.out.println(message);
            System.out.flush();
        }
    }

    private static class ChannelProviderFactoryImpl
    implements ChannelProviderFactory {
        private ChannelProviderFactoryImpl() {
        }

        @Override
        public String getFactoryName() {
            return ClientFactory.PROVIDER_NAME;
        }

        @Override
        public synchronized ChannelProvider sharedInstance() {
            try {
                if (channelProvider == null) {
                    channelProvider = new ChannelProviderImpl();
                }
                return channelProvider;
            }
            catch (Throwable e) {
                throw new RuntimeException("Failed to initialize shared CA client instance.", e);
            }
        }

        @Override
        public ChannelProvider newInstance() {
            try {
                return new ChannelProviderImpl();
            }
            catch (Throwable e) {
                throw new RuntimeException("Failed to initialize new CA client instance.", e);
            }
        }

        public synchronized boolean destroySharedInstance() {
            boolean destroyed = true;
            if (channelProvider != null) {
                try {
                    channelProvider.destroy();
                    channelProvider = null;
                }
                catch (Exception ex) {
                    destroyed = false;
                }
            }
            return destroyed;
        }
    }
}

