/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca;

import gov.aps.jca.CAException;
import gov.aps.jca.CAStatus;
import gov.aps.jca.Channel;
import gov.aps.jca.Monitor;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.event.ConnectionEvent;
import gov.aps.jca.event.ConnectionListener;
import gov.aps.jca.event.GetEvent;
import gov.aps.jca.event.GetListener;
import gov.aps.jca.event.MonitorEvent;
import gov.aps.jca.event.MonitorListener;
import org.epics.ca.BaseV3ChannelStructure;
import org.epics.ca.V3Channel;
import org.epics.ca.V3ChannelStructure;
import org.epics.pvdata.factory.StatusFactory;
import org.epics.pvdata.misc.BitSet;
import org.epics.pvdata.monitor.MonitorElement;
import org.epics.pvdata.monitor.MonitorRequester;
import org.epics.pvdata.pv.MessageType;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.Status;
import org.epics.pvdata.pv.StatusCreate;

public class BaseV3Monitor
implements org.epics.pvdata.monitor.Monitor,
MonitorListener,
GetListener,
ConnectionListener {
    private static final StatusCreate statusCreate = StatusFactory.getStatusCreate();
    private static final Status okStatus = statusCreate.getStatusOK();
    private static final Status channelDestroyedStatus = statusCreate.createStatus(Status.StatusType.ERROR, "channel destroyed", null);
    private static final Status createChannelStructureStatus = statusCreate.createStatus(Status.StatusType.ERROR, "createChannelStructure failed", null);
    private static final Status getInitialStatus = statusCreate.createStatus(Status.StatusType.ERROR, "get initial failed", null);
    private final MonitorRequester monitorRequester;
    private final V3Channel v3Channel;
    private final Channel jcaChannel;
    private final V3ChannelStructure v3ChannelStructure;
    private volatile Monitor monitor = null;
    private volatile boolean isDestroyed = false;
    private volatile BitSet overrunBitSet;
    private volatile MonitorElement monitorElement;
    private final PVStructure pvRequest;

    public BaseV3Monitor(MonitorRequester monitorRequester, V3Channel v3Channel, PVStructure pvRequest) {
        this.monitorRequester = monitorRequester;
        this.v3Channel = v3Channel;
        this.pvRequest = pvRequest;
        v3Channel.add(this);
        this.v3ChannelStructure = new BaseV3ChannelStructure(v3Channel);
        this.jcaChannel = v3Channel.getJCAChannel();
        try {
            this.jcaChannel.addConnectionListener((ConnectionListener)this);
        }
        catch (CAException e) {
            this.overrunBitSet = null;
            this.monitorElement = null;
            monitorRequester.monitorConnect(statusCreate.createStatus(Status.StatusType.ERROR, "addConnectionListener failed", (Throwable)e), null, null);
            this.destroy();
            return;
        }
        if (this.jcaChannel.getConnectionState() == Channel.CONNECTED) {
            this.connectionChanged(new ConnectionEvent(this.jcaChannel, true));
        }
    }

    protected void initializeMonitor() {
        if (this.v3ChannelStructure.createPVStructure(this.pvRequest, true) == null) {
            this.overrunBitSet = null;
            this.monitorElement = null;
            this.monitorRequester.monitorConnect(createChannelStructureStatus, null, null);
            this.destroy();
            return;
        }
        try {
            this.jcaChannel.get(this.v3ChannelStructure.getRequestDBRType(), 0, (GetListener)this);
        }
        catch (Throwable th) {
            this.overrunBitSet = null;
            this.monitorElement = null;
            this.monitorRequester.monitorConnect(getInitialStatus, null, null);
            this.destroy();
            return;
        }
        PVStructure pvStructure = this.v3ChannelStructure.getPVStructure();
        this.overrunBitSet = new BitSet(pvStructure.getNumberFields());
        this.monitorElement = new MonitorElementImpl(pvStructure, this.v3ChannelStructure.getBitSet(), this.overrunBitSet);
    }

    public void destroy() {
        if (this.monitor != null) {
            this.stop();
        }
        this.isDestroyed = true;
        this.v3Channel.remove(this);
        try {
            this.jcaChannel.removeConnectionListener((ConnectionListener)this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Status start() {
        if (this.isDestroyed) {
            return channelDestroyedStatus;
        }
        try {
            this.monitor = this.jcaChannel.addMonitor(this.v3ChannelStructure.getRequestDBRType(), this.jcaChannel.getElementCount(), 255, (MonitorListener)this);
        }
        catch (CAException e) {
            return statusCreate.createStatus(Status.StatusType.ERROR, "failed to start monitor", (Throwable)e);
        }
        return okStatus;
    }

    public Status stop() {
        if (this.isDestroyed) {
            return channelDestroyedStatus;
        }
        try {
            this.monitor.clear();
        }
        catch (CAException e) {
            return statusCreate.createStatus(Status.StatusType.ERROR, "failed to stop monitor", (Throwable)e);
        }
        this.monitor = null;
        return okStatus;
    }

    public void monitorChanged(MonitorEvent monitorEvent) {
        CAStatus caStatus = monitorEvent.getStatus();
        if (!caStatus.isSuccessful()) {
            this.monitorRequester.message(caStatus.getMessage(), MessageType.error);
            return;
        }
        DBR fromDBR = monitorEvent.getDBR();
        if (fromDBR == null) {
            this.monitorRequester.message("fromDBR is null", MessageType.error);
        } else {
            this.v3ChannelStructure.toStructure(fromDBR);
            this.monitorRequester.monitorEvent((org.epics.pvdata.monitor.Monitor)this);
        }
    }

    public MonitorElement poll() {
        if (this.v3ChannelStructure.getBitSet().nextSetBit(0) < 0) {
            return null;
        }
        return this.monitorElement;
    }

    public void release(MonitorElement monitorElement) {
        this.v3ChannelStructure.getBitSet().clear();
    }

    public void getCompleted(GetEvent getEvent) {
        DBR fromDBR = getEvent.getDBR();
        if (fromDBR == null) {
            CAStatus caStatus = getEvent.getStatus();
            this.monitorRequester.monitorConnect(statusCreate.createStatus(Status.StatusType.ERROR, caStatus.getMessage(), null), null, null);
        } else {
            this.v3ChannelStructure.toStructure(fromDBR);
            this.monitorRequester.monitorConnect(okStatus, (org.epics.pvdata.monitor.Monitor)this, this.v3ChannelStructure.getPVStructure().getStructure());
            this.monitorRequester.monitorEvent((org.epics.pvdata.monitor.Monitor)this);
        }
    }

    public void connectionChanged(ConnectionEvent event) {
        if (event.isConnected()) {
            this.initializeMonitor();
        }
    }

    private static class MonitorElementImpl
    implements MonitorElement {
        private final PVStructure pvStructure;
        private final BitSet changedBitSet;
        private final BitSet overrunBitSet;

        MonitorElementImpl(PVStructure pvStructure, BitSet changedBitSet, BitSet overrunBitSet) {
            this.pvStructure = pvStructure;
            this.changedBitSet = changedBitSet;
            this.overrunBitSet = overrunBitSet;
        }

        public BitSet getChangedBitSet() {
            return this.changedBitSet;
        }

        public BitSet getOverrunBitSet() {
            return this.overrunBitSet;
        }

        public PVStructure getPVStructure() {
            return this.pvStructure;
        }
    }
}

