/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca;

import gov.aps.jca.CAStatus;
import gov.aps.jca.Channel;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DBRType;
import gov.aps.jca.event.ConnectionEvent;
import gov.aps.jca.event.ConnectionListener;
import gov.aps.jca.event.GetEvent;
import gov.aps.jca.event.GetListener;
import gov.aps.jca.event.PutEvent;
import gov.aps.jca.event.PutListener;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.epics.ca.BaseV3ChannelStructure;
import org.epics.ca.V3Channel;
import org.epics.ca.V3ChannelStructure;
import org.epics.pvaccess.client.Channel;
import org.epics.pvaccess.client.ChannelPut;
import org.epics.pvaccess.client.ChannelPutRequester;
import org.epics.pvdata.factory.StatusFactory;
import org.epics.pvdata.misc.BitSet;
import org.epics.pvdata.pv.ByteArrayData;
import org.epics.pvdata.pv.DoubleArrayData;
import org.epics.pvdata.pv.FloatArrayData;
import org.epics.pvdata.pv.IntArrayData;
import org.epics.pvdata.pv.MessageType;
import org.epics.pvdata.pv.PVByte;
import org.epics.pvdata.pv.PVByteArray;
import org.epics.pvdata.pv.PVDouble;
import org.epics.pvdata.pv.PVDoubleArray;
import org.epics.pvdata.pv.PVField;
import org.epics.pvdata.pv.PVFloat;
import org.epics.pvdata.pv.PVFloatArray;
import org.epics.pvdata.pv.PVInt;
import org.epics.pvdata.pv.PVIntArray;
import org.epics.pvdata.pv.PVShort;
import org.epics.pvdata.pv.PVShortArray;
import org.epics.pvdata.pv.PVString;
import org.epics.pvdata.pv.PVStringArray;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.ShortArrayData;
import org.epics.pvdata.pv.Status;
import org.epics.pvdata.pv.StatusCreate;
import org.epics.pvdata.pv.StringArrayData;

public class BaseV3ChannelPut
implements ChannelPut,
GetListener,
PutListener,
ConnectionListener {
    private static final StatusCreate statusCreate = StatusFactory.getStatusCreate();
    private static final Status okStatus = statusCreate.getStatusOK();
    private static final Status channelDestroyedStatus = statusCreate.createStatus(Status.StatusType.ERROR, "channel destroyed", null);
    private static final Status channelNotConnectedStatus = statusCreate.createStatus(Status.StatusType.ERROR, "channel not connected", null);
    private static final Status disconnectedWhileActiveStatus = statusCreate.createStatus(Status.StatusType.ERROR, "disconnected while active", null);
    private static final Status createChannelStructureStatus = statusCreate.createStatus(Status.StatusType.ERROR, "createChannelStructure failed", null);
    private final ChannelPutRequester channelPutRequester;
    private final V3Channel v3Channel;
    private final V3ChannelStructure v3ChannelStructure;
    private final gov.aps.jca.Channel jcaChannel;
    private volatile int elementCount;
    private final ReentrantLock lock = new ReentrantLock();
    private volatile boolean isDestroyed = false;
    private volatile boolean lastRequest = false;
    private final ByteArrayData byteArrayData = new ByteArrayData();
    private final ShortArrayData shortArrayData = new ShortArrayData();
    private final IntArrayData intArrayData = new IntArrayData();
    private final FloatArrayData floatArrayData = new FloatArrayData();
    private final DoubleArrayData doubleArrayData = new DoubleArrayData();
    private final StringArrayData stringArrayData = new StringArrayData();
    private final AtomicBoolean isActive = new AtomicBoolean(false);
    private final AtomicBoolean isGetActive = new AtomicBoolean(false);
    private final PVStructure pvRequest;
    private boolean block = false;

    public BaseV3ChannelPut(ChannelPutRequester channelPutRequester, V3Channel v3Channel, PVStructure pvRequest) {
        this.channelPutRequester = channelPutRequester;
        this.v3Channel = v3Channel;
        this.pvRequest = pvRequest;
        v3Channel.add(this);
        this.v3ChannelStructure = new BaseV3ChannelStructure(v3Channel);
        this.jcaChannel = v3Channel.getJCAChannel();
        try {
            this.jcaChannel.addConnectionListener((ConnectionListener)this);
        }
        catch (Throwable th) {
            this.elementCount = 1;
            channelPutRequester.channelPutConnect(statusCreate.createStatus(Status.StatusType.ERROR, "addConnectionListener failed", th), this, null);
            this.destroy();
            return;
        }
        if (this.jcaChannel.getConnectionState() == gov.aps.jca.Channel.CONNECTED) {
            this.connectionChanged(new ConnectionEvent(this.jcaChannel, true));
        }
    }

    protected void initializePut() {
        String value;
        PVString pvString = (PVString)this.pvRequest.getSubField(PVString.class, "record._options.block");
        if (pvString != null && (value = pvString.get()).equals("true")) {
            this.block = true;
        }
        if (this.v3ChannelStructure.createPVStructure(this.pvRequest, true) == null) {
            this.elementCount = 1;
            this.channelPutRequester.channelPutConnect(createChannelStructureStatus, this, null);
            this.destroy();
            return;
        }
        this.elementCount = this.jcaChannel.getElementCount();
        DBRType nativeDBRType = this.v3ChannelStructure.getNativeDBRType();
        if (nativeDBRType.isENUM() && this.elementCount != 1) {
            this.channelPutRequester.channelPutConnect(statusCreate.createStatus(Status.StatusType.ERROR, "array of ENUM not supported", null), this, null);
            this.destroy();
            return;
        }
        this.channelPutRequester.channelPutConnect(okStatus, this, this.v3ChannelStructure.getPVStructure().getStructure());
    }

    public void destroy() {
        this.isDestroyed = true;
        this.v3Channel.remove(this);
        try {
            this.jcaChannel.removeConnectionListener((ConnectionListener)this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void get() {
        if (this.isDestroyed) {
            this.getDone(channelDestroyedStatus);
            return;
        }
        if (this.jcaChannel.getConnectionState() != Channel.ConnectionState.CONNECTED) {
            this.getDone(channelNotConnectedStatus);
            return;
        }
        this.isGetActive.set(true);
        try {
            this.jcaChannel.get(this.v3ChannelStructure.getRequestDBRType(), this.elementCount, (GetListener)this);
        }
        catch (Throwable th) {
            this.getDone(statusCreate.createStatus(Status.StatusType.ERROR, "failed to get", th));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getCompleted(GetEvent getEvent) {
        DBR fromDBR = getEvent.getDBR();
        if (fromDBR == null) {
            CAStatus caStatus = getEvent.getStatus();
            this.getDone(statusCreate.createStatus(Status.StatusType.ERROR, caStatus.toString(), null));
            return;
        }
        this.lock();
        try {
            this.v3ChannelStructure.toStructure(fromDBR);
        }
        finally {
            this.unlock();
        }
        this.getDone(okStatus);
    }

    private void getDone(Status success) {
        if (!this.isGetActive.getAndSet(false)) {
            return;
        }
        if (this.lastRequest) {
            this.destroy();
        }
        this.channelPutRequester.getDone(success, this, this.v3ChannelStructure.getPVStructure(), this.v3ChannelStructure.getBitSet());
    }

    @Override
    public void put(PVStructure pvPutStructure, BitSet bitSet) {
        block32: {
            boolean bitSetCheck;
            if (this.isDestroyed) {
                this.putDone(channelDestroyedStatus);
                return;
            }
            if (this.jcaChannel.getConnectionState() != Channel.ConnectionState.CONNECTED) {
                this.putDone(channelNotConnectedStatus);
                return;
            }
            DBRType nativeDBRType = this.v3ChannelStructure.getNativeDBRType();
            PVField pvField = pvPutStructure.getSubField("value");
            if (pvField == null) {
                this.channelPutRequester.putDone(statusCreate.createStatus(Status.StatusType.ERROR, "invalid put structure, value field required", null), this);
                return;
            }
            PVInt pvIndex = nativeDBRType.isENUM() ? ((PVStructure)pvField).getIntField("index") : null;
            boolean bl = bitSetCheck = bitSet.get(0) || bitSet.get(pvField.getFieldOffset()) || pvIndex != null && bitSet.get(pvIndex.getFieldOffset());
            if (!bitSetCheck) {
                this.channelPutRequester.putDone(statusCreate.createStatus(Status.StatusType.ERROR, "invalid bitSet, only value can be put for CA", null), this);
                return;
            }
            BaseV3ChannelPut callback = this.block ? this : null;
            this.isActive.set(true);
            try {
                if (pvIndex != null) {
                    short index = (short)pvIndex.get();
                    this.jcaChannel.put(index, (PutListener)callback);
                    break block32;
                }
                if (nativeDBRType == DBRType.BYTE) {
                    if (this.elementCount == 1) {
                        PVByte pvFrom = (PVByte)pvField;
                        byte from = pvFrom.get();
                        this.jcaChannel.put(from, (PutListener)callback);
                    } else {
                        PVByteArray fromArray = (PVByteArray)pvField;
                        int len = fromArray.get(0, this.elementCount, this.byteArrayData);
                        byte[] from = (byte[])this.byteArrayData.data;
                        int capacity = fromArray.getCapacity();
                        for (int i = len; i < capacity; ++i) {
                            from[i] = 0;
                        }
                        this.jcaChannel.put(from, (PutListener)callback);
                    }
                    break block32;
                }
                if (nativeDBRType == DBRType.SHORT) {
                    if (this.elementCount == 1) {
                        PVShort pvFrom = (PVShort)pvField;
                        short from = pvFrom.get();
                        this.jcaChannel.put(from, (PutListener)callback);
                    } else {
                        PVShortArray fromArray = (PVShortArray)pvField;
                        int len = fromArray.get(0, this.elementCount, this.shortArrayData);
                        short[] from = (short[])this.shortArrayData.data;
                        int capacity = fromArray.getCapacity();
                        for (int i = len; i < capacity; ++i) {
                            from[i] = 0;
                        }
                        this.jcaChannel.put(from, (PutListener)callback);
                    }
                    break block32;
                }
                if (nativeDBRType == DBRType.INT) {
                    if (this.elementCount == 1) {
                        PVInt pvFrom = (PVInt)pvField;
                        int from = pvFrom.get();
                        this.jcaChannel.put(from, (PutListener)callback);
                    } else {
                        PVIntArray fromArray = (PVIntArray)pvField;
                        int len = fromArray.get(0, this.elementCount, this.intArrayData);
                        int[] from = (int[])this.intArrayData.data;
                        int capacity = fromArray.getCapacity();
                        for (int i = len; i < capacity; ++i) {
                            from[i] = 0;
                        }
                        this.jcaChannel.put(from, (PutListener)callback);
                    }
                    break block32;
                }
                if (nativeDBRType == DBRType.FLOAT) {
                    if (this.elementCount == 1) {
                        PVFloat pvFrom = (PVFloat)pvField;
                        float from = pvFrom.get();
                        this.jcaChannel.put(from, (PutListener)callback);
                    } else {
                        PVFloatArray fromArray = (PVFloatArray)pvField;
                        int len = fromArray.get(0, this.elementCount, this.floatArrayData);
                        float[] from = (float[])this.floatArrayData.data;
                        int capacity = fromArray.getCapacity();
                        for (int i = len; i < capacity; ++i) {
                            from[i] = 0.0f;
                        }
                        this.jcaChannel.put(from, (PutListener)callback);
                    }
                    break block32;
                }
                if (nativeDBRType == DBRType.DOUBLE) {
                    if (this.elementCount == 1) {
                        PVDouble pvFrom = (PVDouble)pvField;
                        double from = pvFrom.get();
                        this.jcaChannel.put(from, (PutListener)callback);
                    } else {
                        PVDoubleArray fromArray = (PVDoubleArray)pvField;
                        int len = fromArray.get(0, this.elementCount, this.doubleArrayData);
                        double[] from = (double[])this.doubleArrayData.data;
                        int capacity = fromArray.getCapacity();
                        for (int i = len; i < capacity; ++i) {
                            from[i] = 0.0;
                        }
                        this.jcaChannel.put(from, (PutListener)callback);
                    }
                    break block32;
                }
                if (nativeDBRType == DBRType.STRING) {
                    if (this.elementCount == 1) {
                        PVString pvFrom = (PVString)pvField;
                        String from = pvFrom.get();
                        this.jcaChannel.put(from, (PutListener)callback);
                    } else {
                        PVStringArray fromArray = (PVStringArray)pvField;
                        int len = fromArray.get(0, this.elementCount, this.stringArrayData);
                        String[] from = (String[])this.stringArrayData.data;
                        int capacity = fromArray.getCapacity();
                        for (int i = len; i < capacity; ++i) {
                            from[i] = "";
                        }
                        this.jcaChannel.put(from, (PutListener)callback);
                    }
                    break block32;
                }
                throw new IllegalArgumentException("unknown DBRType " + nativeDBRType.getName());
            }
            catch (Throwable th) {
                this.putDone(statusCreate.createStatus(Status.StatusType.ERROR, "failed to put", th));
                return;
            }
        }
        if (!this.block) {
            this.putDone(okStatus);
        }
    }

    public void putCompleted(PutEvent event) {
        CAStatus caStatus = event.getStatus();
        if (!caStatus.isSuccessful()) {
            this.putDone(statusCreate.createStatus(Status.StatusType.ERROR, caStatus.toString(), null));
            return;
        }
        this.putDone(okStatus);
    }

    public String getRequesterName() {
        return this.channelPutRequester.getRequesterName();
    }

    public void message(String message, MessageType messageType) {
        this.channelPutRequester.message(message, messageType);
    }

    public void connectionChanged(ConnectionEvent event) {
        if (!event.isConnected()) {
            this.putDone(disconnectedWhileActiveStatus);
            this.getDone(disconnectedWhileActiveStatus);
        } else {
            this.initializePut();
        }
    }

    private void putDone(Status success) {
        if (!this.isActive.getAndSet(false)) {
            return;
        }
        if (this.lastRequest) {
            this.destroy();
        }
        this.channelPutRequester.putDone(success, this);
    }

    @Override
    public void lock() {
        this.lock.lock();
    }

    @Override
    public void unlock() {
        this.lock.unlock();
    }

    @Override
    public void cancel() {
    }

    @Override
    public void lastRequest() {
        this.lastRequest = true;
    }

    @Override
    public Channel getChannel() {
        return this.v3Channel;
    }
}

