/*
 * Decompiled with CFR 0.152.
 */
package gov.bnl.channelfinder.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import gov.bnl.channelfinder.api.XmlProperty;
import gov.bnl.channelfinder.api.XmlTag;
import java.util.ArrayList;
import java.util.List;

@JsonRootName(value="channel")
public class XmlChannel {
    private String name;
    private String owner;
    private List<XmlProperty> properties = new ArrayList<XmlProperty>();
    private List<XmlTag> tags = new ArrayList<XmlTag>();

    public XmlChannel() {
    }

    public XmlChannel(String name) {
        this.name = name;
    }

    public XmlChannel(String name, String owner) {
        this.name = name;
        this.owner = owner;
    }

    public XmlChannel(String name, String owner, List<XmlProperty> properties, List<XmlTag> tags) {
        this.name = name;
        this.owner = owner;
        this.properties = properties;
        this.tags = tags;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="owner")
    public String getOwner() {
        return this.owner;
    }

    @JsonProperty(value="owner")
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @JsonProperty(value="properties")
    public List<XmlProperty> getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    public void setProperties(List<XmlProperty> properties) {
        this.properties = properties;
    }

    public void addXmlProperty(XmlProperty property) {
        this.properties.add(property);
    }

    @JsonProperty(value="tags")
    public List<XmlTag> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    public void setTags(List<XmlTag> tags) {
        this.tags = tags;
    }

    public void addXmlTag(XmlTag tag) {
        this.tags.add(tag);
    }

    public static String toLog(XmlChannel data) {
        return data.getName() + "(" + data.getOwner() + "):[" + data.properties + data.tags + "]";
    }
}

