/*
 * Decompiled with CFR 0.152.
 */
package gov.bnl.channelfinder.api;

import gov.bnl.channelfinder.api.XmlTag;

public class Tag {
    private final String name;
    private final String owner;

    Tag(XmlTag xml) {
        this.name = xml.getName();
        this.owner = xml.getOwner();
    }

    private Tag(Builder builder) {
        this.name = builder.name;
        this.owner = builder.owner;
    }

    public String getName() {
        return this.name;
    }

    public String getOwner() {
        return this.owner;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Tag)) {
            return false;
        }
        Tag other = (Tag)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public static class Builder {
        private String name;
        private String owner = null;

        public static Builder tag(Tag tag) {
            Builder builder = new Builder();
            builder.name = tag.getName();
            builder.owner = tag.getOwner();
            return builder;
        }

        public static Builder tag(String name) {
            Builder builder = new Builder();
            builder.name = name;
            return builder;
        }

        public static Builder tag(String name, String owner) {
            Builder builder = new Builder();
            builder.name = name;
            builder.owner = owner;
            return builder;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public XmlTag toXml() {
            XmlTag xml = new XmlTag();
            xml.setName(this.name);
            xml.setOwner(this.owner);
            return xml;
        }

        public Tag build() {
            return new Tag(this);
        }
    }
}

