/*
 * Decompiled with CFR 0.152.
 */
package gov.bnl.channelfinder.api;

import gov.bnl.channelfinder.api.XmlProperty;

public class Property {
    private final String name;
    private final String owner;
    private final String value;

    Property(XmlProperty xmlProperty) {
        this.name = xmlProperty.getName();
        this.owner = xmlProperty.getOwner();
        this.value = xmlProperty.getValue();
    }

    private Property(Builder builder) {
        this.name = builder.name;
        this.value = builder.value;
        this.owner = builder.owner;
    }

    public String getName() {
        return this.name;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Property)) {
            return false;
        }
        Property other = (Property)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public static class Builder {
        private String name;
        private String owner;
        private String value;

        public static Builder property(String name) {
            Builder propertyBuilder = new Builder();
            propertyBuilder.name = name;
            return propertyBuilder;
        }

        public static Builder property(String name, String value) {
            Builder propertyBuilder = new Builder();
            propertyBuilder.name = name;
            propertyBuilder.value = value;
            return propertyBuilder;
        }

        public static Builder property(Property property) {
            Builder propertyBuilder = new Builder();
            propertyBuilder.name = property.getName();
            propertyBuilder.value = property.getValue();
            propertyBuilder.owner = property.getOwner();
            return propertyBuilder;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public XmlProperty toXml() {
            return new XmlProperty(this.name, this.owner, this.value);
        }

        public Property build() {
            return new Property(this);
        }
    }
}

