/*
 * Decompiled with CFR 0.152.
 */
package gov.bnl.channelfinder.api;

import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

class MyX509TrustManager
implements X509TrustManager {
    X509TrustManager pkixTrustManager;

    MyX509TrustManager(String trustStore, char[] password) throws Exception {
        this(new File(trustStore), password);
    }

    MyX509TrustManager(File trustStore, char[] password) throws Exception {
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(new FileInputStream(trustStore), password);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ks);
        TrustManager[] tms = tmf.getTrustManagers();
        for (int i = 0; i < tms.length; ++i) {
            if (!(tms[i] instanceof X509TrustManager)) continue;
            this.pkixTrustManager = (X509TrustManager)tms[i];
            return;
        }
        throw new Exception("Couldn't initialize");
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.pkixTrustManager.checkClientTrusted(chain, authType);
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.pkixTrustManager.checkServerTrusted(chain, authType);
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.pkixTrustManager.getAcceptedIssuers();
    }
}

