/*
 * Decompiled with CFR 0.152.
 */
package gov.bnl.channelfinder.api;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import gov.bnl.channelfinder.api.Channel;
import gov.bnl.channelfinder.api.Property;
import gov.bnl.channelfinder.api.Tag;
import gov.bnl.channelfinder.api.XmlChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;

public class ChannelUtil {
    private ChannelUtil() {
    }

    public static Collection<String> getTagNames(Channel channel) {
        HashSet<String> tagNames = new HashSet<String>();
        for (Tag tag : channel.getTags()) {
            tagNames.add(tag.getName());
        }
        return tagNames;
    }

    public static Collection<String> getAllTagNames(Collection<Channel> channels) {
        HashSet<String> tagNames = new HashSet<String>();
        for (Channel channel : channels) {
            tagNames.addAll(ChannelUtil.getTagNames(channel));
        }
        return tagNames;
    }

    public static Collection<String> getPropertyNames(Channel channel) {
        HashSet<String> propertyNames = new HashSet<String>();
        for (Property property : channel.getProperties()) {
            if (property.getValue() == null) continue;
            propertyNames.add(property.getName());
        }
        return propertyNames;
    }

    @Deprecated
    public static Tag getTag(Channel channel, String tagName) {
        Collection tag = Collections2.filter(channel.getTags(), (Predicate)new TagNamePredicate(tagName));
        if (tag.size() == 1) {
            return (Tag)tag.iterator().next();
        }
        return null;
    }

    @Deprecated
    public static Property getProperty(Channel channel, String propertyName) {
        Collection property = Collections2.filter(channel.getProperties(), (Predicate)new PropertyNamePredicate(propertyName));
        if (property.size() == 1) {
            return (Property)property.iterator().next();
        }
        return null;
    }

    public static Collection<String> getPropertyNames(Collection<Channel> channels) {
        HashSet<String> propertyNames = new HashSet<String>();
        for (Channel channel : channels) {
            propertyNames.addAll(ChannelUtil.getPropertyNames(channel));
        }
        return propertyNames;
    }

    public static Collection<String> getPropValues(Collection<Channel> channels, String propertyName) {
        TreeSet<String> propertyValues = new TreeSet<String>();
        for (Channel channel : channels) {
            if (channel.getProperty(propertyName) == null || channel.getProperty(propertyName).getValue() == null) continue;
            propertyValues.add(channel.getProperty(propertyName).getValue());
        }
        return propertyValues;
    }

    public static Collection<String> getChannelNames(Collection<Channel> channels) {
        HashSet<String> channelNames = new HashSet<String>();
        for (Channel channel : channels) {
            channelNames.add(channel.getName());
        }
        return channelNames;
    }

    public static Collection<Channel> filterbyProperties(Collection<Channel> channels, Collection<String> propNames) {
        ArrayList<Channel> result = new ArrayList<Channel>();
        ArrayList<Channel> input = new ArrayList<Channel>(channels);
        for (Channel channel : input) {
            if (!channel.getPropertyNames().containsAll(propNames)) continue;
            result.add(channel);
        }
        return result;
    }

    public static Collection<Channel> filterbyTags(Collection<Channel> channels, Collection<String> tagNames) {
        ArrayList<Channel> result = new ArrayList<Channel>();
        ArrayList<Channel> input = new ArrayList<Channel>(channels);
        for (Channel channel : input) {
            if (!channel.getTagNames().containsAll(tagNames)) continue;
            result.add(channel);
        }
        return result;
    }

    public static Collection<Channel> filterbyElements(Collection<Channel> channels, Collection<String> propNames, Collection<String> tagNames) {
        ArrayList<Channel> result = new ArrayList<Channel>();
        ArrayList<Channel> input = new ArrayList<Channel>(channels);
        for (Channel channel : input) {
            if (!channel.getPropertyNames().containsAll(propNames) || !channel.getTagNames().containsAll(tagNames)) continue;
            result.add(channel);
        }
        return result;
    }

    public static Collection<Channel> toChannels(Collection<Channel.Builder> channelBuilders) {
        HashSet<Channel> channels = new HashSet<Channel>();
        for (Channel.Builder builder : channelBuilders) {
            channels.add(builder.build());
        }
        return Collections.unmodifiableCollection(channels);
    }

    public static List<XmlChannel> toCollectionXmlChannels(Collection<Channel.Builder> channelBuilders) {
        ArrayList<XmlChannel> xmlchannels = new ArrayList<XmlChannel>();
        for (Channel.Builder builder : channelBuilders) {
            xmlchannels.add(builder.toXml());
        }
        return xmlchannels;
    }

    private static class PropertyNamePredicate
    implements Predicate<Property> {
        private String propertyName;

        PropertyNamePredicate(String propertyName) {
            this.propertyName = propertyName;
        }

        public boolean apply(Property input) {
            return input.getName().equals(this.propertyName);
        }
    }

    private static class TagNamePredicate
    implements Predicate<Tag> {
        private String tagName;

        TagNamePredicate(String tagName) {
            this.tagName = tagName;
        }

        public boolean apply(Tag input) {
            return input.getName().equals(this.tagName);
        }
    }
}

