/*
 * Decompiled with CFR 0.152.
 */
package gov.bnl.channelfinder.api;

import gov.bnl.channelfinder.api.Channel;
import gov.bnl.channelfinder.api.ChannelFinder;
import gov.bnl.channelfinder.api.ChannelFinderClient;
import gov.bnl.channelfinder.api.ChannelQueryListener;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class ChannelQuery {
    private final ChannelFinderClient client;
    private final String query;
    private static Executor defaultQueryExecutor = Executors.newSingleThreadExecutor();
    private final Executor queryExecutor;
    private volatile Result result;
    private boolean running = false;
    private List<ChannelQueryListener> listeners = new CopyOnWriteArrayList<ChannelQueryListener>();

    public static Builder query(String query) {
        return new Builder(query);
    }

    public static Executor getDefaultQueryExecutor() {
        return defaultQueryExecutor;
    }

    public static void setDefaultQueryExecutor(Executor defaultQueryExecutor) {
        if (defaultQueryExecutor == null) {
            throw new NullPointerException("Executor can't be null");
        }
        ChannelQuery.defaultQueryExecutor = defaultQueryExecutor;
    }

    private ChannelQuery(String query, ChannelFinderClient client, Executor queryExecutor, Result result) {
        this.query = query;
        this.client = client;
        this.queryExecutor = queryExecutor;
        this.result = result;
    }

    public void addChannelQueryListener(ChannelQueryListener listener) {
        this.listeners.add(listener);
    }

    public void removeChannelQueryListener(ChannelQueryListener listener) {
        this.listeners.remove(listener);
    }

    private void fireGetQueryResult(Result result) {
        for (ChannelQueryListener listener : this.listeners) {
            listener.queryExecuted(result);
        }
    }

    public String getQuery() {
        return this.query;
    }

    public Result getResult() {
        return this.result;
    }

    public void execute(ChannelQueryListener listener) {
        this.addChannelQueryListener(listener);
        Result localResult = this.result;
        if (localResult != null) {
            listener.queryExecuted(localResult);
        } else {
            this.execute();
        }
    }

    public void refresh() {
        this.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute() {
        ChannelQuery channelQuery = this;
        synchronized (channelQuery) {
            if (this.running) {
                return;
            }
            this.running = true;
        }
        this.queryExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object channels;
                Result localResult = null;
                try {
                    channels = ChannelQuery.this.client.find(ChannelQuery.this.query);
                    localResult = new Result(null, (Collection<Channel>)channels);
                }
                catch (Exception e) {
                    try {
                        localResult = new Result(e, null);
                    }
                    catch (Throwable throwable) {
                        ChannelQuery.this.result = localResult;
                        1 var6_8 = this;
                        synchronized (var6_8) {
                            ChannelQuery.this.running = false;
                        }
                        ChannelQuery.this.fireGetQueryResult(localResult);
                        throw throwable;
                    }
                    ChannelQuery.this.result = localResult;
                    1 var2_4 = this;
                    synchronized (var2_4) {
                        ChannelQuery.this.running = false;
                    }
                    ChannelQuery.this.fireGetQueryResult(localResult);
                }
                ChannelQuery.this.result = localResult;
                channels = this;
                synchronized (channels) {
                    ChannelQuery.this.running = false;
                }
                ChannelQuery.this.fireGetQueryResult(localResult);
            }
        });
    }

    public int hashCode() {
        return this.getQuery().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ChannelQuery) {
            return this.query.equals(((ChannelQuery)obj).getQuery());
        }
        return false;
    }

    public String toString() {
        return this.getQuery();
    }

    static /* synthetic */ Executor access$100() {
        return defaultQueryExecutor;
    }

    public static class Builder {
        private String query = null;
        private ChannelFinderClient client = ChannelFinder.getClient();
        private Executor queryExecutor = ChannelQuery.access$100();
        private Result result = null;

        private Builder(String query) {
            if (query == null) {
                throw new IllegalArgumentException("query string cannot be null");
            }
            this.query = query;
        }

        public Builder using(ChannelFinderClient client) {
            if (client == null) {
                throw new NullPointerException("Client can't be null");
            }
            this.client = client;
            return this;
        }

        public Builder result(Collection<Channel> channels, Exception exception) {
            this.result = new Result(exception, channels);
            return this;
        }

        public Builder on(Executor executor) {
            if (executor == null) {
                throw new NullPointerException("Executor can't be null");
            }
            this.queryExecutor = executor;
            return this;
        }

        public ChannelQuery build() {
            return new ChannelQuery(this.query, this.client, this.queryExecutor, this.result);
        }
    }

    public static class Result {
        public final Exception exception;
        public final Collection<Channel> channels;

        public Result(Exception exception, Collection<Channel> channels) {
            this.exception = exception;
            this.channels = channels;
        }
    }
}

