/*
 * Decompiled with CFR 0.152.
 */
package gov.bnl.channelfinder.api;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import gov.bnl.channelfinder.api.ClientResponseParser;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.text.html.parser.ParserDelegator;

public class ChannelFinderException
extends RuntimeException {
    private static final long serialVersionUID = 6279865221993808192L;
    private ClientResponse.Status status;

    public ChannelFinderException() {
    }

    public ChannelFinderException(String message) {
        super(message);
    }

    public ChannelFinderException(UniformInterfaceException cause) {
        super(ChannelFinderException.parseErrorMsg(cause), cause);
        this.setStatus(ClientResponse.Status.fromStatusCode((int)cause.getResponse().getStatus()));
    }

    private static String parseErrorMsg(UniformInterfaceException ex) {
        String entity = (String)ex.getResponse().getEntity(String.class);
        try {
            ClientResponseParser callback = new ClientResponseParser();
            StringReader reader = new StringReader(entity);
            new ParserDelegator().parse(reader, callback, false);
            return callback.getMessage();
        }
        catch (IOException e) {
            return "Could not retrieve message from server";
        }
    }

    public ChannelFinderException(ClientResponse.Status status, String message) {
        super(message);
        this.setStatus(status);
    }

    public ChannelFinderException(ClientResponse.Status status, Throwable cause, String message) {
        super(message, cause);
        this.setStatus(status);
    }

    public void setStatus(ClientResponse.Status status) {
        this.status = status;
    }

    public ClientResponse.Status getStatus() {
        return this.status;
    }
}

