/*
 * Decompiled with CFR 0.152.
 */
package gov.bnl.channelfinder.api;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.client.urlconnection.HTTPSProperties;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import gov.bnl.channelfinder.api.CFProperties;
import gov.bnl.channelfinder.api.Channel;
import gov.bnl.channelfinder.api.ChannelFinderClient;
import gov.bnl.channelfinder.api.ChannelFinderException;
import gov.bnl.channelfinder.api.ChannelUtil;
import gov.bnl.channelfinder.api.DummyX509TrustManager;
import gov.bnl.channelfinder.api.Property;
import gov.bnl.channelfinder.api.RawLoggingFilter;
import gov.bnl.channelfinder.api.Tag;
import gov.bnl.channelfinder.api.XmlChannel;
import gov.bnl.channelfinder.api.XmlProperty;
import gov.bnl.channelfinder.api.XmlTag;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;

public class ChannelFinderClientImpl
implements ChannelFinderClient {
    private final WebResource service;
    private final ExecutorService executor;
    private static final String resourceChannels = "resources/channels";
    private static final String resourceProperties = "resources/properties";
    private static final String resourceTags = "resources/tags";

    ChannelFinderClientImpl(URI uri, ClientConfig config, HTTPBasicAuthFilter httpBasicAuthFilter, ExecutorService executor) {
        Client client = Client.create((ClientConfig)config);
        if (httpBasicAuthFilter != null) {
            client.addFilter((ClientFilter)httpBasicAuthFilter);
        }
        client.addFilter((ClientFilter)new RawLoggingFilter(Logger.getLogger(RawLoggingFilter.class.getName())));
        client.setFollowRedirects(Boolean.valueOf(true));
        this.service = client.resource(UriBuilder.fromUri((URI)uri).build(new Object[0]));
        this.executor = executor;
    }

    @Override
    public Collection<String> getAllProperties() {
        return this.wrappedSubmit(new Callable<Collection<String>>(){

            @Override
            public Collection<String> call() throws Exception {
                HashSet<String> allProperties = new HashSet<String>();
                ObjectMapper mapper = new ObjectMapper();
                List xmlproperties = new ArrayList();
                try {
                    xmlproperties = (List)mapper.readValue((String)ChannelFinderClientImpl.this.service.path(ChannelFinderClientImpl.resourceProperties).accept(new String[]{"application/json"}).get(String.class), (TypeReference)new TypeReference<List<XmlProperty>>(){});
                }
                catch (JsonParseException e) {
                    e.printStackTrace();
                }
                catch (JsonMappingException e) {
                    e.printStackTrace();
                }
                catch (ClientHandlerException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                for (XmlProperty xmlproperty : xmlproperties) {
                    allProperties.add(xmlproperty.getName());
                }
                return allProperties;
            }
        });
    }

    @Override
    public Collection<String> getAllTags() {
        return this.wrappedSubmit(new Callable<Collection<String>>(){

            @Override
            public Collection<String> call() throws Exception {
                HashSet<String> allTags = new HashSet<String>();
                ObjectMapper mapper = new ObjectMapper();
                List xmltags = new ArrayList();
                try {
                    xmltags = (List)mapper.readValue((String)ChannelFinderClientImpl.this.service.path(ChannelFinderClientImpl.resourceTags).accept(new String[]{"application/json"}).get(String.class), (TypeReference)new TypeReference<List<XmlTag>>(){});
                }
                catch (JsonParseException e) {
                    e.printStackTrace();
                }
                catch (JsonMappingException e) {
                    e.printStackTrace();
                }
                catch (ClientHandlerException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                for (XmlTag xmltag : xmltags) {
                    allTags.add(xmltag.getName());
                }
                return allTags;
            }
        });
    }

    @Deprecated
    public static void resetPreferences() {
        try {
            Preferences.userNodeForPackage(ChannelFinderClientImpl.class).clear();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Channel getChannel(String channelName) throws ChannelFinderException {
        try {
            return this.wrappedSubmit(new FindByChannelName(channelName));
        }
        catch (ChannelFinderException e) {
            if (e.getStatus().equals((Object)ClientResponse.Status.NOT_FOUND)) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public void set(Channel.Builder channel) throws ChannelFinderException {
        this.wrappedSubmit(new SetChannel(channel.toXml()));
    }

    @Override
    public void set(Collection<Channel.Builder> channels) throws ChannelFinderException {
        this.wrappedSubmit(new SetChannels(ChannelUtil.toCollectionXmlChannels(channels)));
    }

    @Override
    public void set(Tag.Builder tag) {
        this.wrappedSubmit(new SetTag(tag.toXml()));
    }

    @Override
    public void set(Tag.Builder tag, String channelName) throws ChannelFinderException {
        ArrayList<String> channelNames = new ArrayList<String>();
        channelNames.add(channelName);
        this.wrappedSubmit(new SetTag(tag.toXml(), channelNames));
    }

    @Override
    public void set(Tag.Builder tag, Collection<String> channelNames) throws ChannelFinderException {
        this.wrappedSubmit(new SetTag(tag.toXml(), channelNames));
    }

    public void set(Tag.Builder tag, Map<String, String> channelTagMap) {
        this.wrappedSubmit(new SetTag(tag.toXml(), channelTagMap));
    }

    @Override
    public void set(Property.Builder prop) throws ChannelFinderException {
        this.wrappedSubmit(new SetProperty(prop.toXml()));
    }

    @Override
    public void set(Property.Builder prop, String channelName) {
        ArrayList<String> ch = new ArrayList<String>();
        ch.add(channelName);
        this.wrappedSubmit(new SetProperty(prop.toXml(), ch));
    }

    @Override
    public void set(Property.Builder prop, Collection<String> channelNames) {
        this.wrappedSubmit(new SetProperty(prop.toXml(), channelNames));
    }

    @Override
    public void set(Property.Builder prop, Map<String, String> channelPropertyMap) {
        this.wrappedSubmit(new SetProperty(prop.toXml(), channelPropertyMap));
    }

    @Override
    public void update(Channel.Builder channel) throws ChannelFinderException {
        this.wrappedSubmit(new UpdateChannel(channel.toXml()));
    }

    @Override
    public void update(Tag.Builder tag, String channelName) throws ChannelFinderException {
        this.wrappedSubmit(new UpdateTag(tag.toXml(), channelName));
    }

    @Override
    public void update(Tag.Builder tag, Collection<String> channelNames) throws ChannelFinderException {
        this.wrappedSubmit(new UpdateTag(tag.toXml(), channelNames));
    }

    @Override
    public void update(Property.Builder property, String channelName) throws ChannelFinderException {
        this.wrappedSubmit(new UpdateChannelProperty(property.toXml(), channelName));
    }

    @Override
    public void update(Property.Builder property, Collection<String> channelNames) throws ChannelFinderException {
        this.wrappedSubmit(new UpdateProperty(property.toXml(), channelNames));
    }

    @Override
    public void update(Property.Builder property, Map<String, String> channelPropValueMap) throws ChannelFinderException {
        this.wrappedSubmit(new UpdateProperty(property.toXml(), channelPropValueMap));
    }

    @Override
    public Collection<Channel> findByName(String pattern) throws ChannelFinderException {
        HashMap<String, String> searchMap = new HashMap<String, String>();
        searchMap.put("~name", pattern);
        return this.wrappedSubmit(new FindByMap(searchMap));
    }

    @Override
    public Collection<Channel> findByTag(String pattern) throws ChannelFinderException {
        List<String> and = Arrays.asList(pattern.split("&"));
        MultivaluedMapImpl searchMap = new MultivaluedMapImpl();
        for (String string : and) {
            searchMap.add((Object)"~tag", (Object)string);
        }
        return this.wrappedSubmit(new FindByMap((MultivaluedMap<String, String>)searchMap));
    }

    @Override
    public Collection<Channel> findByProperty(String property, String ... pattern) throws ChannelFinderException {
        HashMap<String, String> propertyPatterns = new HashMap<String, String>();
        if (pattern.length > 0) {
            propertyPatterns.put(property, Joiner.on((String)",").join((Object[])pattern));
        } else {
            propertyPatterns.put(property, "*");
        }
        return this.wrappedSubmit(new FindByMap(propertyPatterns));
    }

    @Override
    public Collection<Channel> find(String query) throws ChannelFinderException {
        return this.wrappedSubmit(new FindByMap(ChannelFinderClientImpl.buildSearchMap(query)));
    }

    @Override
    public Collection<Channel> find(Map<String, String> map) throws ChannelFinderException {
        return this.wrappedSubmit(new FindByMap(map));
    }

    @Override
    public Collection<Channel> find(MultivaluedMap<String, String> map) throws ChannelFinderException {
        return this.wrappedSubmit(new FindByMap(map));
    }

    public static MultivaluedMap<String, String> buildSearchMap(String searchPattern) {
        MultivaluedMapImpl map = new MultivaluedMapImpl();
        searchPattern = searchPattern.replaceAll(", ", ",");
        List<String> searchWords = Arrays.asList(searchPattern.split("\\s"));
        ArrayList<String> searchNames = new ArrayList<String>();
        for (String searchWord : searchWords) {
            if (!searchWord.contains("=")) {
                if (searchWord == null || searchWord.isEmpty()) continue;
                searchNames.add(searchWord);
                continue;
            }
            String[] keyValue = searchWord.split("=");
            String key = null;
            try {
                key = keyValue[0];
                String valuePattern = keyValue[1];
                if (key.equalsIgnoreCase("Tags") || key.equalsIgnoreCase("Tag")) {
                    key = "~tag";
                }
                for (String value : valuePattern.split("&")) {
                    map.add((Object)key, (Object)value.trim());
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                if (e.getMessage().equals(String.valueOf(0))) {
                    throw new IllegalArgumentException("= must be preceeded by a propertyName or keyword Tags.");
                }
                if (!e.getMessage().equals(String.valueOf(1))) continue;
                throw new IllegalArgumentException("key: '" + key + "' is specified with no pattern.");
            }
        }
        map.add((Object)"~name", (Object)searchNames.stream().collect(Collectors.joining("&")));
        return map;
    }

    @Override
    public void deleteTag(String tagName) throws ChannelFinderException {
        this.wrappedSubmit(new DeleteElement(resourceTags, tagName));
    }

    @Override
    public void deleteProperty(String propertyName) throws ChannelFinderException {
        this.wrappedSubmit(new DeleteElement(resourceProperties, propertyName));
    }

    @Override
    public void deleteChannel(String channelName) throws ChannelFinderException {
        this.wrappedSubmit(new DeleteElement(resourceChannels, channelName));
    }

    @Override
    @Deprecated
    public void delete(Collection<Channel.Builder> channels) throws ChannelFinderException {
        for (Channel.Builder channel : channels) {
            this.deleteChannel(channel.build().getName());
        }
    }

    @Override
    public void delete(Tag.Builder tag, String channelName) throws ChannelFinderException {
        this.wrappedSubmit(new DeleteElementfromChannel(resourceTags, tag.toXml().getName(), channelName));
    }

    @Override
    public void delete(Tag.Builder tag, Collection<String> channelNames) throws ChannelFinderException {
        for (String channelName : channelNames) {
            this.delete(tag, channelName);
        }
    }

    @Override
    public void delete(Property.Builder property, String channelName) throws ChannelFinderException {
        this.wrappedSubmit(new DeleteElementfromChannel(resourceProperties, property.build().getName(), channelName));
    }

    @Override
    public void delete(Property.Builder property, Collection<String> channelNames) throws ChannelFinderException {
        for (String channel : channelNames) {
            this.delete(property, channel);
        }
    }

    @Override
    public void close() {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
                if (!this.executor.awaitTermination(60L, TimeUnit.SECONDS)) {
                    System.err.println("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private <T> T wrappedSubmit(Callable<T> callable) {
        try {
            return this.executor.submit(callable).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() != null && e.getCause() instanceof UniformInterfaceException) {
                throw new ChannelFinderException((UniformInterfaceException)e.getCause());
            }
            throw new RuntimeException(e);
        }
    }

    private void wrappedSubmit(Runnable runnable) {
        try {
            this.executor.submit(runnable).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() != null && e.getCause() instanceof UniformInterfaceException) {
                throw new ChannelFinderException((UniformInterfaceException)e.getCause());
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public Collection<Channel> getAllChannels() {
        ObjectMapper mapper = new ObjectMapper();
        List xmlchannels = new ArrayList();
        try {
            xmlchannels = (List)mapper.readValue((String)this.service.path(resourceChannels).accept(new String[]{"application/json"}).get(String.class), (TypeReference)new TypeReference<List<XmlChannel>>(){});
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (ClientHandlerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        HashSet<Channel> set = new HashSet<Channel>();
        for (XmlChannel channel : xmlchannels) {
            set.add(new Channel(channel));
        }
        return set;
    }

    private class DeleteElementfromChannel
    implements Runnable {
        private final String elementType;
        private final String elementName;
        private final String channelName;

        DeleteElementfromChannel(String elementType, String elementName, String channelName) {
            this.elementType = elementType;
            this.elementName = elementName;
            this.channelName = channelName;
        }

        @Override
        public void run() {
            ChannelFinderClientImpl.this.service.path(this.elementType).path(this.elementName).path(this.channelName).accept(new String[]{"application/json"}).delete();
        }
    }

    private class DeleteElement
    implements Runnable {
        private final String elementType;
        private final String elementName;

        DeleteElement(String elementType, String elementName) {
            this.elementType = elementType;
            this.elementName = elementName;
        }

        @Override
        public void run() {
            ChannelFinderClientImpl.this.service.path(this.elementType).path(this.elementName).delete();
        }
    }

    private class FindByMap
    implements Callable<Collection<Channel>> {
        private MultivaluedMapImpl map;

        FindByMap(Map<String, String> map) {
            MultivaluedMapImpl mMap = new MultivaluedMapImpl();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String key = entry.getKey();
                for (String value : Arrays.asList(entry.getValue().split(","))) {
                    mMap.add(key, value.trim());
                }
            }
            this.map = mMap;
        }

        FindByMap(MultivaluedMap<String, String> map) {
            this.map = new MultivaluedMapImpl();
            this.map.putAll(map);
        }

        @Override
        public Collection<Channel> call() throws Exception {
            HashSet<Channel> channels = new HashSet<Channel>();
            List xmlchannels = new ArrayList();
            ObjectMapper mapper = new ObjectMapper();
            try {
                xmlchannels = (List)mapper.readValue((String)ChannelFinderClientImpl.this.service.path(ChannelFinderClientImpl.resourceChannels).queryParams((MultivaluedMap)this.map).accept(new String[]{"application/json"}).get(String.class), (TypeReference)new TypeReference<List<XmlChannel>>(){});
            }
            catch (JsonParseException e) {
                e.printStackTrace();
            }
            catch (JsonMappingException e) {
                e.printStackTrace();
            }
            catch (ClientHandlerException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            for (XmlChannel xmlchannel : xmlchannels) {
                channels.add(new Channel(xmlchannel));
            }
            return Collections.unmodifiableCollection(channels);
        }
    }

    private class UpdateProperty
    implements Runnable {
        private XmlProperty pxmlProperty;

        UpdateProperty(XmlProperty xmlProperty) {
            this.pxmlProperty = xmlProperty;
        }

        UpdateProperty(XmlProperty xmlProperty, Collection<String> channelNames) {
            this.pxmlProperty = xmlProperty;
            ArrayList<XmlChannel> channels = new ArrayList<XmlChannel>();
            for (String channelName : channelNames) {
                XmlChannel xmlChannel = new XmlChannel(channelName);
                xmlChannel.addXmlProperty(new XmlProperty(xmlProperty.getName(), xmlProperty.getOwner(), xmlProperty.getValue()));
                channels.add(xmlChannel);
            }
            xmlProperty.setChannels(channels);
        }

        UpdateProperty(XmlProperty xmlProperty, Map<String, String> channelPropValueMap) {
            this.pxmlProperty = xmlProperty;
            ArrayList<XmlChannel> channels = new ArrayList<XmlChannel>();
            for (Map.Entry<String, String> e : channelPropValueMap.entrySet()) {
                XmlChannel xmlChannel = new XmlChannel(e.getKey());
                xmlChannel.addXmlProperty(new XmlProperty(xmlProperty.getName(), xmlProperty.getOwner(), e.getValue()));
                channels.add(xmlChannel);
            }
            xmlProperty.setChannels(channels);
        }

        @Override
        public void run() {
            ObjectMapper mapper = new ObjectMapper();
            try {
                ((WebResource.Builder)ChannelFinderClientImpl.this.service.path(ChannelFinderClientImpl.resourceProperties).path(this.pxmlProperty.getName()).type("application/json").accept(new String[]{"application/json"})).post((Object)mapper.writeValueAsString((Object)this.pxmlProperty));
            }
            catch (UniformInterfaceException e) {
                e.printStackTrace();
            }
            catch (ClientHandlerException e) {
                e.printStackTrace();
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
        }
    }

    private class UpdateChannelProperty
    implements Runnable {
        private final String channelName;
        private XmlProperty pxmlProperty;

        UpdateChannelProperty(XmlProperty xmlProperty, String channelName) {
            this.pxmlProperty = xmlProperty;
            this.channelName = channelName;
            XmlChannel xmlChannel = new XmlChannel(this.channelName);
            ArrayList<XmlChannel> channels = new ArrayList<XmlChannel>();
            channels.add(xmlChannel);
            xmlChannel.addXmlProperty(new XmlProperty(xmlProperty.getName(), xmlProperty.getOwner(), xmlProperty.getValue()));
            xmlProperty.setChannels(channels);
        }

        @Override
        public void run() {
            ObjectMapper mapper = new ObjectMapper();
            try {
                ChannelFinderClientImpl.this.service.path(ChannelFinderClientImpl.resourceProperties).path(this.pxmlProperty.getName()).type("application/json").put((Object)mapper.writeValueAsString((Object)this.pxmlProperty));
            }
            catch (UniformInterfaceException e) {
                e.printStackTrace();
            }
            catch (ClientHandlerException e) {
                e.printStackTrace();
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
        }
    }

    private class UpdateTag
    implements Runnable {
        private XmlTag pxmlTag;

        UpdateTag(XmlTag xmlTag) {
            this.pxmlTag = xmlTag;
        }

        UpdateTag(XmlTag xmlTag, String ChannelName) {
            this.pxmlTag = xmlTag;
            ArrayList<XmlChannel> channels = new ArrayList<XmlChannel>();
            channels.add(new XmlChannel(ChannelName));
            this.pxmlTag.setChannels(channels);
        }

        UpdateTag(XmlTag xmlTag, Collection<String> channelNames) {
            this.pxmlTag = xmlTag;
            ArrayList<XmlChannel> channels = new ArrayList<XmlChannel>();
            for (String channelName : channelNames) {
                channels.add(new XmlChannel(channelName, ""));
            }
            xmlTag.setChannels(channels);
        }

        @Override
        public void run() {
            ObjectMapper mapper = new ObjectMapper();
            try {
                ChannelFinderClientImpl.this.service.path(ChannelFinderClientImpl.resourceTags).path(this.pxmlTag.getName()).type("application/json").put((Object)mapper.writeValueAsString((Object)this.pxmlTag));
            }
            catch (UniformInterfaceException e) {
                e.printStackTrace();
            }
            catch (ClientHandlerException e) {
                e.printStackTrace();
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
        }
    }

    private class UpdateChannel
    implements Runnable {
        private XmlChannel channel;

        UpdateChannel(XmlChannel channel) {
            this.channel = channel;
        }

        @Override
        public void run() {
            ObjectMapper mapper = new ObjectMapper();
            try {
                ChannelFinderClientImpl.this.service.path(ChannelFinderClientImpl.resourceChannels).path(this.channel.getName()).type("application/json").post((Object)mapper.writeValueAsString((Object)this.channel));
            }
            catch (UniformInterfaceException e) {
                e.printStackTrace();
            }
            catch (ClientHandlerException e) {
                e.printStackTrace();
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
        }
    }

    private class SetProperty
    implements Runnable {
        private XmlProperty pxmlProperty;

        SetProperty(XmlProperty prop) {
            this.pxmlProperty = prop;
        }

        SetProperty(XmlProperty prop, Map<String, String> channelPropertyMap) {
            this.pxmlProperty = prop;
            ArrayList<XmlChannel> channels = new ArrayList<XmlChannel>();
            for (Map.Entry<String, String> e : channelPropertyMap.entrySet()) {
                XmlChannel xmlChannel = new XmlChannel(e.getKey());
                xmlChannel.addXmlProperty(new XmlProperty(this.pxmlProperty.getName(), this.pxmlProperty.getOwner(), e.getValue()));
                channels.add(xmlChannel);
            }
            this.pxmlProperty.setChannels(channels);
        }

        SetProperty(XmlProperty prop, Collection<String> channelNames) {
            this.pxmlProperty = prop;
            ArrayList<XmlChannel> channels = new ArrayList<XmlChannel>();
            for (String channelName : channelNames) {
                XmlChannel xmlChannel = new XmlChannel(channelName);
                xmlChannel.addXmlProperty(new XmlProperty(this.pxmlProperty.getName(), this.pxmlProperty.getOwner(), this.pxmlProperty.getValue()));
                channels.add(xmlChannel);
            }
            this.pxmlProperty.setChannels(channels);
        }

        @Override
        public void run() {
            ObjectMapper mapper = new ObjectMapper();
            try {
                ((WebResource.Builder)ChannelFinderClientImpl.this.service.path(ChannelFinderClientImpl.resourceProperties).path(this.pxmlProperty.getName()).type("application/json").accept(new String[]{"application/json"})).put((Object)mapper.writeValueAsString((Object)this.pxmlProperty));
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
        }
    }

    private class SetTag
    implements Runnable {
        private XmlTag pxmlTag;

        public SetTag(XmlTag xmlTag) {
            this.pxmlTag = xmlTag;
        }

        SetTag(XmlTag xmlTag, Map<String, String> channelTagMap) {
            this.pxmlTag = xmlTag;
            ArrayList<XmlChannel> channels = new ArrayList<XmlChannel>();
            for (Map.Entry<String, String> e : channelTagMap.entrySet()) {
                XmlChannel xmlChannel = new XmlChannel(e.getKey());
                xmlChannel.addXmlProperty(new XmlProperty(this.pxmlTag.getName(), this.pxmlTag.getOwner(), e.getValue()));
                channels.add(xmlChannel);
            }
            this.pxmlTag.setChannels(channels);
        }

        SetTag(XmlTag xmlTag, Collection<String> channelNames) {
            this.pxmlTag = xmlTag;
            ArrayList<XmlChannel> channels = new ArrayList<XmlChannel>();
            for (String channelName : channelNames) {
                XmlChannel xmlChannel = new XmlChannel(channelName);
                xmlChannel.addXmlTag(new XmlTag(this.pxmlTag.getName(), this.pxmlTag.getOwner()));
                channels.add(xmlChannel);
            }
            this.pxmlTag.setChannels(channels);
        }

        @Override
        public void run() {
            ObjectMapper mapper = new ObjectMapper();
            try {
                ((WebResource.Builder)ChannelFinderClientImpl.this.service.path(ChannelFinderClientImpl.resourceTags).path(this.pxmlTag.getName()).type("application/json").accept(new String[]{"application/json"})).put((Object)mapper.writeValueAsString((Object)this.pxmlTag));
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
        }
    }

    private class SetChannels
    implements Runnable {
        private List<XmlChannel> pxmlchannels = null;

        public SetChannels(List<XmlChannel> xmlchannels) {
            this.pxmlchannels = xmlchannels;
        }

        @Override
        public void run() {
            ObjectMapper mapper = new ObjectMapper();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                mapper.writeValue((OutputStream)out, this.pxmlchannels);
                byte[] data = out.toByteArray();
                String test = new String(data);
                ChannelFinderClientImpl.this.service.path(ChannelFinderClientImpl.resourceChannels).type("application/json").put((Object)test);
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private class SetChannel
    implements Runnable {
        private XmlChannel pxmlChannel = new XmlChannel();

        public SetChannel(XmlChannel xmlChannel) {
            this.pxmlChannel = xmlChannel;
        }

        @Override
        public void run() {
            ObjectMapper mapper = new ObjectMapper();
            try {
                ChannelFinderClientImpl.this.service.path(ChannelFinderClientImpl.resourceChannels).path(this.pxmlChannel.getName()).type("application/json").put((Object)mapper.writeValueAsString((Object)this.pxmlChannel));
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
        }
    }

    private class FindByChannelName
    implements Callable<Channel> {
        private final String channelName;

        FindByChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public Channel call() throws UniformInterfaceException {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
            try {
                return new Channel((XmlChannel)mapper.readValue(((ClientResponse)ChannelFinderClientImpl.this.service.path(ChannelFinderClientImpl.resourceChannels).path(this.channelName).get(ClientResponse.class)).getEntityInputStream(), XmlChannel.class));
            }
            catch (JsonParseException e) {
                e.printStackTrace();
            }
            catch (JsonMappingException e) {
                e.printStackTrace();
            }
            catch (ClientHandlerException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static class CFCBuilder {
        private URI uri = null;
        private boolean withHTTPAuthentication = false;
        private HTTPBasicAuthFilter httpBasicAuthFilter = null;
        private ClientConfig clientConfig = null;
        private TrustManager[] trustManager = new TrustManager[]{new DummyX509TrustManager()};
        private SSLContext sslContext = null;
        private String protocol = null;
        private String username = null;
        private String password = null;
        private ExecutorService executor = Executors.newSingleThreadExecutor();
        private CFProperties properties = new CFProperties();
        private static final String serviceURL = "http://localhost:8080/ChannelFinder";

        private CFCBuilder() {
            this.uri = URI.create(this.properties.getPreferenceValue("channelfinder.serviceURL", serviceURL));
            this.protocol = this.uri.getScheme();
        }

        private CFCBuilder(URI uri) {
            this.uri = uri;
            this.protocol = this.uri.getScheme();
        }

        public static CFCBuilder serviceURL() {
            return new CFCBuilder();
        }

        public static CFCBuilder serviceURL(String uri) {
            return new CFCBuilder(URI.create(uri));
        }

        public static CFCBuilder serviceURL(URI uri) {
            return new CFCBuilder(uri);
        }

        public CFCBuilder withHTTPAuthentication(boolean withHTTPAuthentication) {
            this.withHTTPAuthentication = withHTTPAuthentication;
            return this;
        }

        public CFCBuilder username(String username) {
            this.username = username;
            return this;
        }

        public CFCBuilder password(String password) {
            this.password = password;
            return this;
        }

        public CFCBuilder withClientConfig(ClientConfig clientConfig) {
            this.clientConfig = clientConfig;
            return this;
        }

        private CFCBuilder withSSLContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public CFCBuilder withTrustManager(TrustManager[] trustManager) {
            this.trustManager = trustManager;
            return this;
        }

        public CFCBuilder withExecutor(ExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public ChannelFinderClient create() throws ChannelFinderException {
            if (this.protocol.equalsIgnoreCase("http")) {
                this.clientConfig = new DefaultClientConfig();
            } else if (this.protocol.equalsIgnoreCase("https") && this.clientConfig == null) {
                SSLContext sslContext = null;
                try {
                    sslContext = SSLContext.getInstance("SSL");
                    sslContext.init(null, this.trustManager, null);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new ChannelFinderException(e.getMessage());
                }
                catch (KeyManagementException e) {
                    throw new ChannelFinderException(e.getMessage());
                }
                this.clientConfig = new DefaultClientConfig();
                this.clientConfig.getProperties().put("com.sun.jersey.client.impl.urlconnection.httpsProperties", new HTTPSProperties(new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                }, sslContext));
            }
            if (this.withHTTPAuthentication) {
                this.httpBasicAuthFilter = new HTTPBasicAuthFilter(this.ifNullReturnPreferenceValue(this.username, "channelfinder.username", "username"), this.ifNullReturnPreferenceValue(this.password, "channelfinder.password", "password"));
            }
            return new ChannelFinderClientImpl(this.uri, this.clientConfig, this.httpBasicAuthFilter, this.executor);
        }

        private String ifNullReturnPreferenceValue(String value, String key, String Default) {
            if (value == null) {
                return this.properties.getPreferenceValue(key, Default);
            }
            return value;
        }
    }
}

