/*
 * Decompiled with CFR 0.152.
 */
package gov.bnl.channelfinder.api;

import gov.bnl.channelfinder.api.Property;
import gov.bnl.channelfinder.api.Tag;
import gov.bnl.channelfinder.api.XmlChannel;
import gov.bnl.channelfinder.api.XmlProperty;
import gov.bnl.channelfinder.api.XmlTag;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Channel {
    private final String name;
    private final String owner;
    private final Map<String, Tag> tags;
    private final Map<String, Property> properties;

    Channel(XmlChannel channel) {
        this.name = channel.getName();
        this.owner = channel.getOwner();
        HashMap<String, Tag> newTags = new HashMap<String, Tag>();
        for (XmlTag tag : channel.getTags()) {
            newTags.put(tag.getName(), new Tag(tag));
        }
        this.tags = Collections.unmodifiableMap(newTags);
        HashMap<String, Property> newProperties = new HashMap<String, Property>();
        for (XmlProperty property : channel.getProperties()) {
            newProperties.put(property.getName(), new Property(property));
        }
        this.properties = Collections.unmodifiableMap(newProperties);
    }

    private Channel(Builder builder) {
        this.name = builder.name;
        this.owner = builder.owner;
        HashMap<String, Tag> newTags = new HashMap<String, Tag>();
        for (Tag.Builder tag : builder.tags) {
            newTags.put(tag.build().getName(), tag.build());
        }
        this.tags = Collections.unmodifiableMap(newTags);
        HashMap<String, Property> newProperties = new HashMap<String, Property>();
        for (Property.Builder property : builder.properties) {
            newProperties.put(property.build().getName(), property.build());
        }
        this.properties = Collections.unmodifiableMap(newProperties);
    }

    public String getName() {
        return this.name;
    }

    public String getOwner() {
        return this.owner;
    }

    public Collection<Tag> getTags() {
        return this.tags.values();
    }

    public Tag getTag(String tagName) {
        return this.tags.get(tagName);
    }

    public Collection<String> getTagNames() {
        return this.tags.keySet();
    }

    public Collection<Property> getProperties() {
        return this.properties.values();
    }

    public Property getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    public Collection<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Channel)) {
            return false;
        }
        Channel other = (Channel)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return "Channel [name=" + this.name + ", owner=" + this.owner + "]";
    }

    public static class Builder {
        private String name;
        private String owner;
        private Set<Tag.Builder> tags = new HashSet<Tag.Builder>();
        private Set<Property.Builder> properties = new HashSet<Property.Builder>();

        public static Builder channel(Channel channel) {
            Builder channelBuilder = new Builder();
            channelBuilder.name = channel.getName();
            channelBuilder.owner = channel.getOwner();
            for (Tag tag : channel.getTags()) {
                channelBuilder.tags.add(Tag.Builder.tag(tag));
            }
            for (Property property : channel.getProperties()) {
                channelBuilder.properties.add(Property.Builder.property(property));
            }
            return channelBuilder;
        }

        public static Builder channel(String name) {
            Builder channelBuilder = new Builder();
            channelBuilder.name = name;
            return channelBuilder;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public Builder with(Tag.Builder tag) {
            this.tags.add(tag);
            return this;
        }

        public Builder withTags(Collection<Tag.Builder> tags) {
            for (Tag.Builder tag : tags) {
                this.tags.add(tag);
            }
            return this;
        }

        public Builder with(Property.Builder property) {
            this.properties.add(property);
            return this;
        }

        public Builder withProperties(Collection<Property.Builder> properties) {
            for (Property.Builder property : properties) {
                this.properties.add(property);
            }
            return this;
        }

        public XmlChannel toXml() {
            XmlChannel xmlChannel = new XmlChannel(this.name, this.owner);
            for (Tag.Builder tag : this.tags) {
                xmlChannel.addXmlTag(tag.toXml());
            }
            for (Property.Builder property : this.properties) {
                xmlChannel.addXmlProperty(property.toXml());
            }
            return xmlChannel;
        }

        public Channel build() {
            return new Channel(this);
        }
    }
}

