/*
 * Decompiled with CFR 0.152.
 */
package gov.bnl.channelfinder.api;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

class CFProperties {
    private static Properties defaultProperties;
    private static Properties userCFProperties;
    private static Properties userHomeCFProperties;
    private static Properties systemCFProperties;

    public CFProperties() {
        try {
            File userCFPropertiesFile = new File(System.getProperty("channelfinder.properties", ""));
            File userHomeCFPropertiesFile = new File(System.getProperty("user.home") + "/channelfinder.properties");
            File systemCFPropertiesFile = null;
            systemCFPropertiesFile = System.getProperty("os.name").startsWith("Windows") ? new File("/channelfinder.properties") : (System.getProperty("os.name").startsWith("Linux") ? new File("/etc/channelfinder.properties") : new File("/etc/channelfinder.properties"));
            defaultProperties = new Properties();
            try {
                defaultProperties.load(this.getClass().getResourceAsStream("/config/channelfinder.properties"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            systemCFProperties = new Properties(defaultProperties);
            if (systemCFPropertiesFile.exists()) {
                systemCFProperties.load(new FileInputStream(systemCFPropertiesFile));
            }
            userHomeCFProperties = new Properties(systemCFProperties);
            if (userHomeCFPropertiesFile.exists()) {
                userHomeCFProperties.load(new FileInputStream(userHomeCFPropertiesFile));
            }
            userCFProperties = new Properties(userHomeCFProperties);
            if (userCFPropertiesFile.exists()) {
                userCFProperties.load(new FileInputStream(userCFPropertiesFile));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getPreferenceValue(String key, String defaultValue) {
        if (userCFProperties.containsKey(key)) {
            return userCFProperties.getProperty(key);
        }
        if (userHomeCFProperties.containsKey(key)) {
            return userHomeCFProperties.getProperty(key);
        }
        if (systemCFProperties.containsKey(key)) {
            return systemCFProperties.getProperty(key);
        }
        if (defaultProperties.containsKey(key)) {
            return defaultProperties.getProperty(key);
        }
        return defaultValue;
    }
}

