/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.lints;

import org.eolang.lints.Severity;

public interface Defect {
    public String rule();

    public Severity severity();

    public int line();

    public String text();

    public static final class Default
    implements Defect {
        private final String rle;
        private final Severity sev;
        private final int lineno;
        private final String txt;

        public Default(String rule, Severity severity, int line, String text) {
            this.rle = rule;
            this.sev = severity;
            this.lineno = line;
            this.txt = text;
        }

        public String toString() {
            return String.format("[%s %s]:%d %s", new Object[]{this.rle, this.sev, this.lineno, this.txt});
        }

        @Override
        public String rule() {
            return this.rle;
        }

        @Override
        public Severity severity() {
            return this.sev;
        }

        @Override
        public int line() {
            return this.lineno;
        }

        @Override
        public String text() {
            return this.txt;
        }
    }
}

