/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.lints;

import com.jcabi.xml.XML;
import com.jcabi.xml.XMLDocument;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import org.cactoos.iterable.Sticky;
import org.cactoos.iterable.Synced;
import org.eolang.lints.Defect;
import org.eolang.lints.Lint;
import org.eolang.lints.MonoWithout;
import org.eolang.lints.PkMono;
import org.eolang.lints.ScopedDefects;

public final class Source {
    private static final Iterable<Lint<XML>> MONO = new Synced((Iterable)new Sticky((Iterable)((Object)new PkMono())));
    private final XML xmir;
    private final Iterable<Lint<XML>> lints;

    public Source(Path file) throws FileNotFoundException {
        this((XML)new XMLDocument(file));
    }

    public Source(XML xml) {
        this(xml, MONO);
    }

    Source(XML xml, Iterable<Lint<XML>> list) {
        this.xmir = xml;
        this.lints = list;
    }

    public Source without(String ... names) {
        return new Source(this.xmir, (Iterable<Lint<XML>>)((Object)new MonoWithout(names)));
    }

    public Collection<Defect> defects() {
        try {
            ArrayList<Defect> messages = new ArrayList<Defect>(0);
            for (Lint<XML> lint : this.lints) {
                messages.addAll((Collection<Defect>)((Object)new ScopedDefects(lint.defects(this.xmir), "Single")));
            }
            return messages;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to find defects in the XMIR file", ex);
        }
    }
}

