/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.lints;

import com.jcabi.xml.XML;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.cactoos.Input;
import org.cactoos.Text;
import org.cactoos.io.ResourceOf;
import org.cactoos.text.IoCheckedText;
import org.cactoos.text.TextOf;
import org.eolang.lints.Defect;
import org.eolang.lints.Lint;
import org.eolang.lints.Severity;

final class LtUnitTestMissing
implements Lint<Map<String, XML>> {
    LtUnitTestMissing() {
    }

    @Override
    public Collection<Defect> defects(Map<String, XML> pkg) throws IOException {
        ArrayList<Defect> defects = new ArrayList<Defect>(0);
        for (String name : pkg.keySet()) {
            if (name.endsWith("-tests")) continue;
            String lookup = String.format("%s-tests", name);
            if (pkg.containsKey(lookup)) continue;
            defects.add(new Defect.Default("unit-test-missing", Severity.WARNING, name, 0, String.format("Tests \"%s\" not found for \"%s\"", lookup, name)));
        }
        return defects;
    }

    @Override
    public String name() {
        return "unit-test-missing";
    }

    @Override
    public String motive() throws IOException {
        return new IoCheckedText((Text)new TextOf((Input)new ResourceOf((CharSequence)String.format("org/eolang/motives/units/%s.md", this.name())))).asString();
    }
}

