/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.lints;

import com.github.lombrozo.xnav.Xnav;
import com.jcabi.xml.XML;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.cactoos.Input;
import org.cactoos.Text;
import org.cactoos.io.ResourceOf;
import org.cactoos.text.TextOf;
import org.cactoos.text.UncheckedText;
import org.eolang.lints.Defect;
import org.eolang.lints.Lint;
import org.eolang.lints.ReservedNames;
import org.eolang.lints.Severity;
import org.eolang.parser.ObjectName;

final class LtReservedName
implements Lint<XML> {
    private final Map<String, String> reserved;

    LtReservedName() {
        this((Map<String, String>)((Object)new ReservedNames()));
    }

    LtReservedName(Map<String, String> names) {
        this.reserved = names;
    }

    @Override
    public String name() {
        return "reserved-name";
    }

    @Override
    public Collection<Defect> defects(XML xmir) throws IOException {
        ArrayList<Defect> defects = new ArrayList<Defect>(0);
        Xnav source = new Xnav(xmir.inner());
        source.path("//o[@name]").forEach(object -> {
            String oname = (String)object.attribute("name").text().get();
            if (this.reserved.keySet().contains(oname)) {
                defects.add(new Defect.Default(this.name(), Severity.WARNING, new ObjectName(xmir).get(), Integer.parseInt(object.attribute("line").text().orElse("0")), String.format("Object name \"%s\" is already reserved by object in the \"%s\"", oname, this.reserved.get(oname))));
            }
        });
        return defects;
    }

    @Override
    public String motive() throws IOException {
        return new UncheckedText((Text)new TextOf((Input)new ResourceOf((CharSequence)String.format("org/eolang/motives/names/%s.md", this.name())))).asString();
    }
}

