/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.lints;

import com.github.lombrozo.xnav.Filter;
import com.github.lombrozo.xnav.Xnav;
import com.jcabi.xml.XML;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.cactoos.Input;
import org.cactoos.Text;
import org.cactoos.io.ResourceOf;
import org.cactoos.list.ListOf;
import org.cactoos.text.TextOf;
import org.cactoos.text.UncheckedText;
import org.eolang.lints.Defect;
import org.eolang.lints.Lint;
import org.eolang.lints.Severity;

final class LtIncorrectNumberOfAttrs
implements Lint<Map<String, XML>> {
    LtIncorrectNumberOfAttrs() {
    }

    @Override
    public Collection<Defect> defects(Map<String, XML> pkg) throws IOException {
        ArrayList<Defect> defects = new ArrayList<Defect>(0);
        Map<String, Integer> definitions = LtIncorrectNumberOfAttrs.objectDefinitions(pkg);
        pkg.forEach((program, xmir) -> new Xnav(xmir.inner()).path("//o[@base and not(@base='\u2205')]").forEach(xnav -> {
            int provided = (int)xnav.elements(new Filter[]{Filter.withName((String)"o")}).count();
            String object = xnav.attribute("base").text().orElse("unknown");
            Integer expected = (Integer)definitions.get(object);
            if (expected != null && provided != expected) {
                defects.add(new Defect.Default(this.name(), Severity.ERROR, (String)program, Integer.parseInt(xnav.attribute("line").text().orElse("0")), String.format("The object \"%s\" expects %d arguments, while %d provided", object, expected, provided)));
            }
        }));
        return defects;
    }

    @Override
    public String name() {
        return "incorrect-number-of-attributes";
    }

    @Override
    public String motive() throws IOException {
        return new UncheckedText((Text)new TextOf((Input)new ResourceOf((CharSequence)String.format("org/eolang/motives/errors/%s.md", this.name())))).asString();
    }

    private static Map<String, Integer> objectDefinitions(Map<String, XML> pkg) {
        HashMap<String, Integer> definitions = new HashMap<String, Integer>(0);
        pkg.forEach((program, xmir) -> {
            Xnav xml = new Xnav(xmir.inner());
            xml.element("object").elements(new Filter[]{Filter.withName((String)"o")}).forEach(xob -> {
                ListOf attrs = new ListOf((Object[])new Xnav[0]);
                xob.path("o[@base='\u2205']").forEach(((List)attrs)::add);
                String name = xob.attribute("name").text().orElse("unknown");
                definitions.put(LtIncorrectNumberOfAttrs.packagedFqn(name, xml), attrs.size());
            });
        });
        return definitions;
    }

    private static String packagedFqn(String oname, Xnav xml) {
        List packages = xml.element("object").element("metas").elements(new Filter[]{Filter.withName((String)"meta")}).filter(meta -> "package".equals(meta.element("head").text().get())).collect(Collectors.toList());
        String pack = packages.isEmpty() ? "org.eolang" : (String)((Xnav)packages.get(0)).element("tail").text().get();
        return String.format("Q.%s.%s", pack, oname);
    }
}

