/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.lints;

import com.github.lombrozo.xnav.Xnav;
import com.jcabi.xml.XML;
import com.jcabi.xml.XMLDocument;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cactoos.Input;
import org.cactoos.Text;
import org.cactoos.io.ResourceOf;
import org.cactoos.list.ListOf;
import org.cactoos.text.TextOf;
import org.cactoos.text.UncheckedText;
import org.eolang.lints.Defect;
import org.eolang.lints.Lint;
import org.eolang.lints.Severity;
import org.eolang.parser.ObjectName;

final class LtInconsistentArgs
implements Lint<Map<String, XML>> {
    LtInconsistentArgs() {
    }

    @Override
    public String name() {
        return "inconsistent-args";
    }

    @Override
    public Collection<Defect> defects(Map<String, XML> pkg) throws IOException {
        ArrayList<Defect> defects = new ArrayList<Defect>(0);
        Map<Xnav, Map<String, List<Integer>>> whole = LtInconsistentArgs.scanUsages(pkg);
        Map<String, List<Xnav>> bases = LtInconsistentArgs.baseOccurrences(whole);
        LtInconsistentArgs.mergedSources(whole).forEach((base, counts) -> {
            if (counts.stream().distinct().count() != 1L) {
                List sources = (List)bases.get(base);
                Map<String, List<Integer>> clashes = LtInconsistentArgs.clashes(sources, base);
                sources.forEach(src -> src.path(String.format("//o[@base='%s']", LtInconsistentArgs.relativizeToTopObject(base, src))).forEach(o -> {
                    String current = new ObjectName((XML)new XMLDocument(src.node())).get();
                    int cline = Integer.parseInt(o.attribute("line").text().orElse("0"));
                    defects.add(new Defect.Default(this.name(), Severity.WARNING, current, cline, String.format("Object '%s' has arguments inconsistency (the usage clashes with [%s])", base, LtInconsistentArgs.objectClashes(clashes, current, cline))));
                }));
            }
        });
        return defects;
    }

    @Override
    public String motive() throws IOException {
        return new UncheckedText((Text)new TextOf((Input)new ResourceOf((CharSequence)String.format("org/eolang/motives/misc/%s.md", this.name())))).asString();
    }

    private static Map<Xnav, Map<String, List<Integer>>> scanUsages(Map<String, XML> pkg) {
        HashMap<Xnav, Map<String, List<Integer>>> usages = new HashMap<Xnav, Map<String, List<Integer>>>(0);
        pkg.values().forEach(xmir -> {
            HashMap local = new HashMap(0);
            Xnav source = new Xnav(xmir.inner());
            source.path("//o[@base]").forEach(o -> {
                int args = o.node().getChildNodes().getLength();
                String base = (String)o.attribute("base").text().get();
                String ref = base.startsWith("$.") ? String.format("%s.%s", new ObjectName(source).get(), base) : base;
                local.computeIfAbsent(ref, k -> new ListOf((Object[])new Integer[0])).add(args);
            });
            usages.put(source, local);
        });
        return usages;
    }

    private static Map<String, List<Integer>> mergedSources(Map<Xnav, Map<String, List<Integer>>> whole) {
        HashMap<String, List<Integer>> merged = new HashMap<String, List<Integer>>(0);
        whole.forEach((xnav, localized) -> localized.forEach((base, counts) -> merged.computeIfAbsent((String)base, k -> new ListOf((Object[])new Integer[0])).addAll(counts)));
        return merged;
    }

    private static Map<String, List<Xnav>> baseOccurrences(Map<Xnav, Map<String, List<Integer>>> whole) {
        HashMap<String, List<Xnav>> result = new HashMap<String, List<Xnav>>(0);
        whole.forEach((src, local) -> local.forEach((base, value) -> result.computeIfAbsent((String)base, k -> new ListOf((Object[])new Xnav[0])).add(src)));
        return result;
    }

    private static Map<String, List<Integer>> clashes(Iterable<Xnav> sources, String base) {
        HashMap<String, List<Integer>> clashes = new HashMap<String, List<Integer>>(16);
        sources.forEach(src -> src.path(String.format("//o[@base='%s']", LtInconsistentArgs.relativizeToTopObject(base, src))).forEach(o -> {
            String program = new ObjectName((XML)new XMLDocument(src.node())).get();
            int line = Integer.parseInt(o.attribute("line").text().orElse("0"));
            clashes.computeIfAbsent(program, k -> new ListOf((Object[])new Integer[0])).add(line);
        }));
        return clashes;
    }

    private static String objectClashes(Map<String, List<Integer>> clashes, String current, int oline) {
        ListOf others = new ListOf((Object[])new String[0]);
        clashes.forEach((arg_0, arg_1) -> LtInconsistentArgs.lambda$objectClashes$16(current, oline, (Collection)others, arg_0, arg_1));
        return String.join((CharSequence)", ", (Iterable<? extends CharSequence>)others);
    }

    private static String relativizeToTopObject(String base, Xnav source) {
        String top = new ObjectName(source).get();
        String result = base.startsWith(String.format("%s.$.", top)) ? base.replace(String.format("%s.", new ObjectName(source).get()), "") : base;
        return result;
    }

    private static /* synthetic */ void lambda$objectClashes$16(String current, int oline, Collection others, String program, List lines) {
        lines.forEach(line -> {
            if (!program.equals(current) || line != oline) {
                others.add(String.format("%s:%d", program, line));
            }
        });
    }
}

