/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.lints;

import com.github.lombrozo.xnav.Filter;
import com.github.lombrozo.xnav.Xnav;
import com.jcabi.xml.ClasspathSources;
import com.jcabi.xml.Sources;
import com.jcabi.xml.XML;
import com.jcabi.xml.XMLDocument;
import com.jcabi.xml.XSL;
import com.jcabi.xml.XSLDocument;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.cactoos.Input;
import org.cactoos.Text;
import org.cactoos.io.ResourceOf;
import org.cactoos.text.IoCheckedText;
import org.cactoos.text.TextOf;
import org.eolang.lints.Defect;
import org.eolang.lints.DfContext;
import org.eolang.lints.Lint;
import org.eolang.lints.MeasuredXsl;
import org.eolang.lints.Severity;
import org.eolang.parser.ObjectName;

final class LtByXsl
implements Lint<XML> {
    private final String rule;
    private final XSL sheet;
    private final Input doc;

    LtByXsl(String xsl) throws IOException {
        this((Input)new ResourceOf((CharSequence)String.format("org/eolang/lints/%s.xsl", xsl)), (Input)new ResourceOf((CharSequence)String.format("org/eolang/motives/%s.md", xsl)));
    }

    LtByXsl(Input xsl, Input motive) throws IOException {
        XMLDocument xml = new XMLDocument(new IoCheckedText((Text)new TextOf(xsl)).asString());
        this.rule = (String)new Xnav(new String[]{xml.toString()}).element("xsl:stylesheet").attribute("id").text().orElseThrow();
        this.sheet = new MeasuredXsl(this.rule, new XSLDocument((XML)xml, this.rule).with((Sources)new ClasspathSources()));
        this.doc = motive;
    }

    @Override
    public String name() {
        return this.rule;
    }

    @Override
    public Collection<Defect> defects(XML xmir) {
        XML report = this.sheet.transform(xmir);
        ArrayList<Defect> defects = new ArrayList<Defect>(0);
        for (XML defect : LtByXsl.findDefects(report)) {
            Xnav xml = new Xnav(defect.inner());
            Optional sever = xml.attribute("severity").text();
            if (sever.isEmpty()) {
                throw new IllegalStateException(String.format("No severity reported by %s", this.rule));
            }
            defects.add(new DfContext(new Defect.Default(this.rule, Severity.parsed((String)sever.get()), new ObjectName(xmir).get(), this.lineno(xml), (String)xml.text().get(), LtByXsl.experimental(xml)), xml.attribute("context").text().orElse("")));
        }
        return defects;
    }

    @Override
    public String motive() throws IOException {
        return new IoCheckedText((Text)new TextOf(this.doc)).asString();
    }

    private static boolean experimental(Xnav defect) {
        Optional attr = defect.attribute("experimental").text();
        boolean result = attr.isEmpty() ? false : Boolean.parseBoolean((String)attr.get());
        return result;
    }

    private int lineno(Xnav defect) {
        int lineno;
        Optional oline = defect.attribute("line").text();
        if (oline.isEmpty()) {
            throw new IllegalStateException(String.format("No line number reported by %s", this.rule));
        }
        String line = (String)oline.get();
        if (line.isEmpty()) {
            throw new IllegalStateException(String.format("Empty line number reported by %s", this.rule));
        }
        try {
            lineno = Integer.parseInt(line);
        }
        catch (NumberFormatException ex) {
            throw new IllegalStateException(String.format("Wrong line number reported by %s: '%s'", this.rule, line), ex);
        }
        return lineno;
    }

    private static Collection<XML> findDefects(XML report) {
        return new Xnav(report.inner()).element("defects").elements(new Filter[]{Filter.withName((String)"defect")}).map(Xnav::copy).map(Xnav::node).map(XMLDocument::new).collect(Collectors.toList());
    }
}

