/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.lints;

import com.github.lombrozo.xnav.Xnav;
import com.jcabi.xml.ClasspathSources;
import com.jcabi.xml.Sources;
import com.jcabi.xml.XML;
import com.jcabi.xml.XMLDocument;
import com.jcabi.xml.XSL;
import com.jcabi.xml.XSLDocument;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.cactoos.Input;
import org.cactoos.Text;
import org.cactoos.io.ResourceOf;
import org.cactoos.io.UncheckedInput;
import org.cactoos.list.ListOf;
import org.cactoos.text.TextOf;
import org.cactoos.text.UncheckedText;
import org.eolang.lints.Defect;
import org.eolang.lints.Lint;
import org.eolang.lints.Severity;
import org.eolang.parser.ObjectName;

final class LtAtomIsNotUnique
implements Lint<Map<String, XML>> {
    private final XSL pre;

    LtAtomIsNotUnique() {
        this(new XSLDocument(new UncheckedInput((Input)new ResourceOf((CharSequence)"org/eolang/funcs/atom-fqns.xsl")).stream()).with((Sources)new ClasspathSources()));
    }

    LtAtomIsNotUnique(XSL sheet) {
        this.pre = sheet;
    }

    @Override
    public String name() {
        return "atom-is-not-unique";
    }

    @Override
    public Collection<Defect> defects(Map<String, XML> pkg) {
        ArrayList<Defect> defects = new ArrayList<Defect>(0);
        Map index = pkg.values().stream().map(arg_0 -> ((XSL)this.pre).transform(arg_0)).map(xmir -> new Xnav(xmir.inner())).collect(Collectors.toMap(Function.identity(), LtAtomIsNotUnique::fqns));
        HashSet checked = new HashSet(0);
        index.forEach((xmir, fqns) -> {
            fqns.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)).forEach((aname, count) -> IntStream.range(0, Math.toIntExact(count)).forEach(pos -> defects.add(this.singleDefect((Xnav)xmir, (String)aname, pos))));
            index.forEach((next, names) -> {
                String pair;
                if (!Objects.equals(next, xmir) && !checked.contains(pair = LtAtomIsNotUnique.pairHash(xmir, next))) {
                    checked.add(pair);
                    names.stream().filter(fqns::contains).forEach(aname -> {
                        defects.add(this.sharedDefect((Xnav)next, (Xnav)xmir, (String)aname));
                        defects.add(this.sharedDefect((Xnav)xmir, (Xnav)next, (String)aname));
                    });
                }
            });
        });
        return defects;
    }

    @Override
    public String motive() {
        return new UncheckedText((Text)new TextOf((Input)new ResourceOf((CharSequence)String.format("org/eolang/motives/errors/%s.md", this.name())))).asString();
    }

    private Defect singleDefect(Xnav xml, String fqn, int pos) {
        return new Defect.Default(this.name(), Severity.ERROR, new ObjectName((XML)new XMLDocument(xml.node())).get(), Integer.parseInt((String)xml.path(String.format("//o[@name='%s' and o[@name='\u03bb']]", LtAtomIsNotUnique.oname(fqn))).map(o -> (String)o.attribute("line").text().get()).collect(Collectors.toList()).get(pos)), String.format("Atom \"%s\" is duplicated", fqn));
    }

    private Defect sharedDefect(Xnav xml, Xnav original, String fqn) {
        return new Defect.Default(this.name(), Severity.ERROR, new ObjectName((XML)new XMLDocument(xml.node())).get(), Integer.parseInt((String)xml.path(String.format("//o[@name='%s' and o[@name='\u03bb']]", LtAtomIsNotUnique.oname(fqn))).map(xnav -> xnav.attribute("line").text().orElse("0")).collect(Collectors.toList()).get(0)), String.format("Atom with FQN \"%s\" is duplicated, original was found in \"%s\"", fqn, new ObjectName((XML)new XMLDocument(original.node())).get()));
    }

    private static List<String> fqns(Xnav xml) {
        List result;
        List fqns = xml.path("//o[@fqn]").map(o -> (String)o.attribute("fqn").text().get()).collect(Collectors.toList());
        if (xml.path("/object/metas/meta[head='package']").count() == 1L) {
            String pack = (String)xml.one("/object/metas/meta[head='package']/tail").text().get();
            result = fqns.stream().map(fqn -> String.format("%s.%s", pack, fqn)).collect(Collectors.toList());
        } else {
            result = fqns;
        }
        return result.stream().map(fqn -> String.format("\u0424.%s", fqn)).collect(Collectors.toList());
    }

    private static String pairHash(Xnav first, Xnav second) {
        String pair = first.hashCode() < second.hashCode() ? String.format("%d:%d", first.hashCode(), second.hashCode()) : String.format("%d:%d", second.hashCode(), first.hashCode());
        return pair;
    }

    private static String oname(String fqn) {
        ListOf parts = new ListOf((Object[])fqn.split("\\."));
        String result = parts.size() > 1 ? (String)parts.get(parts.size() - 1) : (String)parts.get(0);
        return result;
    }
}

