/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.lints;

import com.jcabi.log.Logger;
import com.jcabi.xml.Sources;
import com.jcabi.xml.XML;
import com.jcabi.xml.XSL;

final class MeasuredXsl
implements XSL {
    private static final long DEFAULT = 100L;
    private final String rule;
    private final XSL origin;
    private final long threshold;

    MeasuredXsl(String name, XSL decorated) {
        this(name, decorated, 100L);
    }

    private MeasuredXsl(String name, XSL decorated, long threshold) {
        this.rule = name;
        this.origin = decorated;
        this.threshold = threshold;
    }

    public XML transform(XML xml) {
        long start = System.currentTimeMillis();
        XML res = this.origin.transform(xml);
        long end = System.currentTimeMillis();
        if (end - start > this.threshold) {
            Logger.warn((Object)this, (String)"XSL transformation '%s' took %[ms]s, whereas threshold is %[ms]s\n", (Object[])new Object[]{this.rule, end - start, this.threshold});
        }
        return res;
    }

    public String applyTo(XML xml) {
        return this.origin.applyTo(xml);
    }

    public XSL with(Sources src) {
        return this.origin.with(src);
    }

    public XSL with(String name, Object value) {
        return this.origin.with(name, value);
    }
}

