/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.lints;

import com.github.lombrozo.xnav.Xnav;
import com.jcabi.xml.XML;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.cactoos.Input;
import org.cactoos.Text;
import org.cactoos.io.ResourceOf;
import org.cactoos.list.ListOf;
import org.cactoos.text.IoCheckedText;
import org.cactoos.text.TextOf;
import org.eolang.lints.Defect;
import org.eolang.lints.DefectMissing;
import org.eolang.lints.Lint;
import org.eolang.lints.Severity;
import org.eolang.parser.ObjectName;

final class LtUnlintNonExistingDefectWpa
implements Lint<Map<String, XML>> {
    private final Iterable<Lint<Map<String, XML>>> lints;
    private final Collection<String> excluded;

    LtUnlintNonExistingDefectWpa(Iterable<Lint<Map<String, XML>>> lnts) {
        this(lnts, (Collection<String>)new ListOf((Object[])new String[0]));
    }

    LtUnlintNonExistingDefectWpa(Iterable<Lint<Map<String, XML>>> lnts, Collection<String> exld) {
        this.lints = lnts;
        this.excluded = exld;
    }

    @Override
    public String name() {
        return "unlint-non-existing-defect";
    }

    @Override
    public Collection<Defect> defects(Map<String, XML> pkg) {
        LinkedList<Defect> defects = new LinkedList<Defect>();
        Map<XML, Map<String, List<Integer>>> existing = this.existingDefects(pkg);
        pkg.values().forEach(xmir -> {
            Xnav xml = new Xnav(xmir.inner());
            DefectMissing missing = new DefectMissing((Map)existing.get(xmir), this.excluded);
            xml.path("/object/metas/meta[head='unlint']/tail").map(xnav -> (String)xnav.text().get()).collect(Collectors.toSet()).stream().filter(missing::apply).forEach(unlint -> xml.path(String.format("object/metas/meta[head='unlint' and tail='%s']/@line", unlint)).map(xnav -> (String)xnav.text().get()).collect(Collectors.toList()).forEach(line -> defects.add(new Defect.Default(this.name(), Severity.WARNING, new ObjectName(xmir).get(), Integer.parseInt(line), String.format("Unlinting rule '%s' doesn't make sense, since there are no defects with it", unlint)))));
        });
        return defects;
    }

    @Override
    public String motive() throws IOException {
        return new IoCheckedText((Text)new TextOf((Input)new ResourceOf((CharSequence)String.format("org/eolang/motives/misc/%s.md", this.name())))).asString();
    }

    private Map<XML, Map<String, List<Integer>>> existingDefects(Map<String, XML> pkg) {
        HashMap<XML, Map<String, List<Integer>>> aggregated = new HashMap<XML, Map<String, List<Integer>>>(0);
        this.lints.forEach(wpl -> {
            try {
                Collection<Defect> defects = wpl.defects(pkg);
                defects.forEach(defect -> pkg.values().forEach(program -> aggregated.computeIfAbsent((XML)program, k -> new HashMap()).computeIfAbsent(defect.rule(), k -> new ListOf((Object[])new Integer[0])).add(defect.line())));
            }
            catch (IOException exception) {
                throw new IllegalStateException(String.format("IO operation failed while linting program with %s", wpl.name()), exception);
            }
        });
        return aggregated;
    }
}

