/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.lints;

import com.github.lombrozo.xnav.Xnav;
import com.jcabi.xml.XML;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.cactoos.list.ListOf;
import org.eolang.lints.Defect;
import org.eolang.lints.Lint;

final class LtUnlint
implements Lint<XML> {
    private static final Pattern LINE_NUMBER = Pattern.compile(".*:\\d+$");
    private final Lint<XML> origin;

    LtUnlint(Lint<XML> lint) {
        this.origin = lint;
    }

    @Override
    public String name() {
        return this.origin.name();
    }

    @Override
    public Collection<Defect> defects(XML xmir) throws IOException {
        ArrayList<Defect> defects = new ArrayList<Defect>(0);
        String lname = this.origin.name();
        Collection<Defect> found = this.origin.defects(xmir);
        List<Integer> problematic = found.stream().filter(defect -> defect.rule().equals(lname)).map(Defect::line).collect(Collectors.toList());
        List<String> granular = new Xnav(xmir.inner()).path(String.format("/object/metas/meta[head='unlint' and (tail='%s' or starts-with(tail, '%s:'))]/tail", lname, lname)).map(xnav -> (String)xnav.text().get()).collect(Collectors.toList());
        boolean global = !granular.isEmpty();
        AtomicBoolean added = new AtomicBoolean(false);
        granular.forEach(unlint -> {
            if (LINE_NUMBER.matcher((CharSequence)unlint).matches()) {
                ListOf split = new ListOf((Object[])unlint.split(":"));
                int lineno = Integer.parseInt((String)split.get(1));
                problematic.removeIf(line -> line == lineno);
            } else {
                problematic.clear();
            }
        });
        problematic.forEach(line -> found.forEach(defect -> {
            if (line != 0 && defect.line() == line.intValue()) {
                defects.add((Defect)defect);
                added.set(true);
            }
        }));
        if (!added.get() && !global) {
            defects.addAll(this.origin.defects(xmir));
        }
        return defects;
    }

    @Override
    public String motive() throws IOException {
        return this.origin.motive();
    }
}

