/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.lints;

import com.jcabi.xml.XML;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.cactoos.Input;
import org.cactoos.Text;
import org.cactoos.io.ResourceOf;
import org.cactoos.text.IoCheckedText;
import org.cactoos.text.TextOf;
import org.eolang.lints.Defect;
import org.eolang.lints.Lint;
import org.eolang.lints.Severity;

final class LtUnitTestWithoutLiveFile
implements Lint<Map<String, XML>> {
    LtUnitTestWithoutLiveFile() {
    }

    @Override
    public String name() {
        return "unit-test-without-live-file";
    }

    @Override
    public Collection<Defect> defects(Map<String, XML> pkg) {
        LinkedList<Defect> defects = new LinkedList<Defect>();
        for (String name : pkg.keySet()) {
            String live;
            if (!name.endsWith("-test") || pkg.containsKey(live = name.replace("-test", ""))) continue;
            defects.add(new Defect.Default(this.name(), Severity.WARNING, name, 0, String.format("Live \".eo\" file \"%s\" was not found for \"%s\"", live, name)));
        }
        return defects;
    }

    @Override
    public String motive() throws IOException {
        return new IoCheckedText((Text)new TextOf((Input)new ResourceOf((CharSequence)String.format("org/eolang/motives/units/%s.md", this.name())))).asString();
    }
}

