/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.lints;

import com.github.lombrozo.xnav.Xnav;
import com.jcabi.xml.XML;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSTaggerME;
import org.cactoos.Input;
import org.cactoos.Text;
import org.cactoos.io.ResourceOf;
import org.cactoos.io.UncheckedInput;
import org.cactoos.list.ListOf;
import org.cactoos.text.TextOf;
import org.cactoos.text.UncheckedText;
import org.eolang.lints.Defect;
import org.eolang.lints.Lint;
import org.eolang.lints.Severity;
import org.eolang.parser.ObjectName;

final class LtTestNotVerb
implements Lint<XML> {
    private static final Pattern KEBAB = Pattern.compile("-");
    private final POSTaggerME model;

    LtTestNotVerb() {
        this(LtTestNotVerb.defaultPosModel());
    }

    LtTestNotVerb(POSModel mdl) {
        this(new POSTaggerME(mdl));
    }

    LtTestNotVerb(POSTaggerME pos) {
        this.model = pos;
    }

    @Override
    public Collection<Defect> defects(XML xmir) throws IOException {
        LinkedList<Defect> defects = new LinkedList<Defect>();
        Xnav xml = new Xnav(xmir.inner());
        List objects = xml.path("/object[metas/meta[head='tests']]/o[@name]").collect(Collectors.toList());
        for (Xnav object : objects) {
            String name = (String)object.attribute("name").text().get();
            String first = (String)new ListOf((Object[])this.model.tag((String[])Stream.concat(Stream.of("It"), Arrays.stream(KEBAB.split(name))).map(s -> s.toLowerCase(Locale.ROOT)).toArray(String[]::new))).get(1);
            if ("VBZ".equals(first)) continue;
            defects.add(new Defect.Default("unit-test-is-not-verb", Severity.WARNING, new ObjectName(xmir).get(), Integer.parseInt(object.attribute("line").text().orElse("0")), String.format("Test object name: \"%s\" doesn't start with verb in singular form", name)));
        }
        return defects;
    }

    @Override
    public String motive() throws IOException {
        return new UncheckedText((Text)new TextOf((Input)new ResourceOf((CharSequence)"org/eolang/motives/misc/test-object-is-not-verb-in-singular.md"))).asString();
    }

    @Override
    public String name() {
        return "unit-test-is-not-verb";
    }

    private static POSModel defaultPosModel() {
        try {
            return new POSModel(new UncheckedInput((Input)new ResourceOf((CharSequence)"en-pos-perceptron.bin")).stream());
        }
        catch (IOException exception) {
            throw new IllegalStateException("Failed to read from I/O", exception);
        }
    }
}

