/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.lints;

import com.github.lombrozo.xnav.Xnav;
import com.jcabi.xml.XML;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.cactoos.Input;
import org.cactoos.Text;
import org.cactoos.io.InputOf;
import org.cactoos.io.ResourceOf;
import org.cactoos.io.UncheckedInput;
import org.cactoos.list.ListOf;
import org.cactoos.text.TextOf;
import org.cactoos.text.UncheckedText;
import org.eolang.lints.Defect;
import org.eolang.lints.Lint;
import org.eolang.lints.Severity;
import org.eolang.parser.EoSyntax;
import org.eolang.parser.ObjectName;

final class LtReservedName
implements Lint<XML> {
    private static final Pattern HOME_OBJECTS = Pattern.compile(".*/downloaded/home/objects");
    private static final Pattern NON_UNIX = Pattern.compile("\\\\");
    private final Map<String, String> reserved;

    LtReservedName() {
        this(LtReservedName.home(Paths.get("downloaded", "home").toString()));
    }

    LtReservedName(Map<String, String> names) {
        this.reserved = names;
    }

    @Override
    public String name() {
        return "reserved-name";
    }

    @Override
    public Collection<Defect> defects(XML xmir) throws IOException {
        LinkedList<Defect> defects = new LinkedList<Defect>();
        Xnav source = new Xnav(xmir.inner());
        source.path("//o[@name]").forEach(object -> {
            String oname = (String)object.attribute("name").text().get();
            if (this.reserved.keySet().contains(oname)) {
                defects.add(new Defect.Default(this.name(), Severity.WARNING, new ObjectName(xmir).get(), Integer.parseInt(object.attribute("line").text().orElse("0")), String.format("Object name \"%s\" is already reserved by object in the \"%s\"", oname, this.reserved.get(oname))));
            }
        });
        return defects;
    }

    @Override
    public String motive() throws IOException {
        return new UncheckedText((Text)new TextOf((Input)new ResourceOf((CharSequence)String.format("org/eolang/motives/names/%s.md", this.name())))).asString();
    }

    private static Map<String, String> home(String location) {
        ListOf names;
        block12: {
            names = new ListOf((Object[])new Map[0]);
            URL resource = Thread.currentThread().getContextClassLoader().getResource(location);
            Predicate<Path> sources = p -> {
                String file = p.toString().replace("\\", "/");
                return file.endsWith(".eo") && file.contains(Path.of(location, new String[0]).resolve("objects").resolve("org").resolve("eolang").toString().replace("\\", "/"));
            };
            if ("jar".equals(resource.getProtocol())) {
                URI uri = URI.create(String.format("jar:file:%s", resource.getFile().substring(5, resource.getFile().indexOf(33))));
                try (FileSystem mount = FileSystems.newFileSystem(uri, Collections.emptyMap());){
                    Files.walk(mount.getPath(location, new String[0]), new FileVisitOption[0]).filter(sources).forEach(arg_0 -> LtReservedName.lambda$home$2((List)names, arg_0));
                    break block12;
                }
                catch (IOException exception) {
                    throw new IllegalStateException("Failed to read home objects from JAR", exception);
                }
            }
            try {
                Files.walk(Paths.get(resource.toURI()), new FileVisitOption[0]).filter(sources).forEach(arg_0 -> LtReservedName.lambda$home$3((List)names, arg_0));
            }
            catch (IOException exception) {
                throw new IllegalStateException("Failed to walk through files", exception);
            }
            catch (URISyntaxException exception) {
                throw new IllegalStateException("URI syntax is broken", exception);
            }
        }
        return names.stream().flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static Map<String, String> namesInFile(Path path) {
        XML parsed;
        try {
            parsed = new EoSyntax((Input)new UncheckedInput((Input)new InputOf(path.toFile()))).parsed();
        }
        catch (IOException exception) {
            throw new IllegalStateException(String.format("Failed to parse EO source in \"%s\"", path), exception);
        }
        return LtReservedName.namesInXmir(parsed, path);
    }

    private static Map<String, String> namesInJar(Path path) {
        XML parsed;
        try (InputStream input = Files.newInputStream(path, new OpenOption[0]);){
            parsed = new EoSyntax(new TextOf(input).asString()).parsed();
        }
        catch (Exception exception) {
            throw new IllegalStateException(String.format("Failed to parse EO source in \"%s\"", path), exception);
        }
        return LtReservedName.namesInXmir(parsed, path);
    }

    private static Map<String, String> namesInXmir(XML xmir, Path path) {
        HashMap<String, String> names = new HashMap<String, String>(64);
        new Xnav(xmir.inner()).path("/object/o/@name").map(oname -> (String)oname.text().get()).forEach(oname -> names.put((String)oname, HOME_OBJECTS.matcher(NON_UNIX.matcher(path.toString()).replaceAll("/")).replaceFirst("").substring(1).replace("/", ".").replace("\"", ".")));
        return names;
    }

    private static /* synthetic */ void lambda$home$3(List names, Path eo) {
        names.add(LtReservedName.namesInFile(eo));
    }

    private static /* synthetic */ void lambda$home$2(List names, Path eo) {
        names.add(LtReservedName.namesInJar(eo));
    }
}

