/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.lints;

import com.github.lombrozo.xnav.Xnav;
import com.jcabi.xml.XML;
import com.jcabi.xml.XMLDocument;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.cactoos.Input;
import org.cactoos.Text;
import org.cactoos.io.ResourceOf;
import org.cactoos.list.ListOf;
import org.cactoos.text.TextOf;
import org.cactoos.text.UncheckedText;
import org.eolang.lints.Defect;
import org.eolang.lints.Lint;
import org.eolang.lints.Severity;
import org.eolang.parser.ObjectName;

final class LtInconsistentArgs
implements Lint<Map<String, XML>> {
    LtInconsistentArgs() {
    }

    @Override
    public String name() {
        return "inconsistent-args";
    }

    @Override
    public Collection<Defect> defects(Map<String, XML> pkg) throws IOException {
        LinkedList<Defect> defects = new LinkedList<Defect>();
        Map<Xnav, Map<String, List<Integer>>> whole = LtInconsistentArgs.scanUsages(pkg);
        Map<String, List<Xnav>> bases = LtInconsistentArgs.baseOccurrences(whole);
        LtInconsistentArgs.mergedSources(whole).forEach((base, counts) -> {
            if (counts.stream().distinct().count() != 1L) {
                List sources = (List)bases.get(base);
                sources.forEach(src -> src.path(String.format("//o[@base='%s']", base)).map(o -> Integer.parseInt(o.attribute("line").text().orElse("0"))).forEach(line -> defects.add(new Defect.Default(this.name(), Severity.WARNING, new ObjectName((XML)new XMLDocument(src.node())).get(), (int)line, String.format("Object '%s' has arguments inconsistency", base)))));
            }
        });
        return defects;
    }

    @Override
    public String motive() throws IOException {
        return new UncheckedText((Text)new TextOf((Input)new ResourceOf((CharSequence)String.format("org/eolang/motives/misc/%s.md", this.name())))).asString();
    }

    private static Map<Xnav, Map<String, List<Integer>>> scanUsages(Map<String, XML> pkg) {
        HashMap<Xnav, Map<String, List<Integer>>> usages = new HashMap<Xnav, Map<String, List<Integer>>>(0);
        pkg.values().forEach(xmir -> {
            HashMap local = new HashMap(0);
            Xnav source = new Xnav(xmir.inner());
            source.path("//o[@base]").forEach(base -> {
                int args = base.node().getChildNodes().getLength();
                local.computeIfAbsent((String)base.attribute("base").text().get(), k -> new ListOf((Object[])new Integer[0])).add(args);
            });
            usages.put(source, local);
        });
        return usages;
    }

    private static Map<String, List<Integer>> mergedSources(Map<Xnav, Map<String, List<Integer>>> whole) {
        HashMap<String, List<Integer>> merged = new HashMap<String, List<Integer>>(0);
        whole.forEach((xnav, localized) -> localized.forEach((base, counts) -> merged.computeIfAbsent((String)base, k -> new ListOf((Object[])new Integer[0])).addAll(counts)));
        return merged;
    }

    private static Map<String, List<Xnav>> baseOccurrences(Map<Xnav, Map<String, List<Integer>>> whole) {
        HashMap<String, List<Xnav>> result = new HashMap<String, List<Xnav>>(0);
        whole.forEach((src, local) -> local.forEach((base, value) -> result.computeIfAbsent((String)base, k -> new ListOf((Object[])new Xnav[0])).add(src)));
        return result;
    }
}

