/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.lints;

import com.jcabi.manifests.Manifests;
import java.util.Objects;
import org.eolang.lints.Severity;

public interface Defect {
    public String rule();

    public Severity severity();

    public String program();

    public int line();

    public String text();

    public String version();

    public String context();

    public boolean experimental();

    public static final class Default
    implements Defect {
        private final String rle;
        private final Severity sev;
        private final String prg;
        private final int lineno;
        private final String txt;
        private final boolean experiment;

        public Default(String rule, Severity severity, String program, int line, String text) {
            this(rule, severity, program, line, text, false);
        }

        public Default(String rule, Severity severity, String program, int line, String text, boolean exprmnt) {
            this.rle = rule;
            this.sev = severity;
            this.prg = program;
            this.lineno = line;
            this.txt = text;
            this.experiment = exprmnt;
        }

        public String toString() {
            StringBuilder text = new StringBuilder(0).append('[').append(this.prg).append(' ').append(this.rle).append(' ').append((Object)this.sev).append(']');
            if (this.lineno > 0) {
                text.append(':').append(this.lineno);
            }
            return text.append(' ').append(this.txt).toString();
        }

        @Override
        public String rule() {
            return this.rle;
        }

        @Override
        public Severity severity() {
            return this.sev;
        }

        @Override
        public String program() {
            return this.prg;
        }

        @Override
        public int line() {
            return this.lineno;
        }

        @Override
        public String text() {
            return this.txt;
        }

        @Override
        public String version() {
            return Manifests.read((String)"Lints-Version");
        }

        @Override
        public String context() {
            return "Context is empty";
        }

        @Override
        public boolean experimental() {
            return this.experiment;
        }

        public boolean equals(Object obj) {
            boolean result;
            if (obj == null || this.getClass() != obj.getClass()) {
                result = false;
            } else {
                Default defect = (Default)obj;
                result = this.lineno == defect.lineno && Objects.equals(this.rle, defect.rle) && this.sev == defect.sev && Objects.equals(this.prg, defect.prg) && Objects.equals(this.txt, defect.txt);
            }
            return result;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.rle, this.sev, this.prg, this.lineno, this.txt});
        }
    }
}

