<?xml version="1.0" encoding="UTF-8"?>
<!--
 * SPDX-FileCopyrightText: Copyright (c) 2016-2025 Objectionary.com
 * SPDX-License-Identifier: MIT
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:eo="https://www.eolang.org" id="duplicate-names" version="2.0">
  <xsl:import href="/org/eolang/funcs/lineno.xsl"/>
  <xsl:import href="/org/eolang/funcs/escape.xsl"/>
  <xsl:output encoding="UTF-8" method="xml"/>
  <xsl:template match="/">
    <defects>
      <xsl:for-each select="//o|/program/objects">
        <xsl:apply-templates select="." mode="dups"/>
      </xsl:for-each>
    </defects>
  </xsl:template>
  <xsl:template match="o|objects" mode="dups">
    <xsl:for-each select="o[@name]">
      <xsl:variable name="x" select="."/>
      <xsl:if test="preceding-sibling::o/@name = $x/@name">
        <xsl:element name="defect">
          <xsl:attribute name="line">
            <xsl:value-of select="eo:lineno(@line)"/>
          </xsl:attribute>
          <xsl:attribute name="severity">
            <xsl:text>critical</xsl:text>
          </xsl:attribute>
          <xsl:text>The name </xsl:text>
          <xsl:value-of select="eo:escape(@name)"/>
          <xsl:text> is already in use</xsl:text>
        </xsl:element>
      </xsl:if>
    </xsl:for-each>
  </xsl:template>
</xsl:stylesheet>
