/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.lints;

import com.github.lombrozo.xnav.Xnav;
import com.jcabi.xml.XML;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.cactoos.Input;
import org.cactoos.Text;
import org.cactoos.io.ResourceOf;
import org.cactoos.list.ListOf;
import org.cactoos.text.IoCheckedText;
import org.cactoos.text.TextOf;
import org.eolang.lints.Defect;
import org.eolang.lints.Lint;
import org.eolang.lints.Severity;

final class LtUnlintNonExistingDefectWpa
implements Lint<Map<String, XML>> {
    private final Iterable<Lint<Map<String, XML>>> lints;

    LtUnlintNonExistingDefectWpa(Iterable<Lint<Map<String, XML>>> lnts) {
        this.lints = lnts;
    }

    @Override
    public String name() {
        return "unlint-non-existing-defect";
    }

    @Override
    public Collection<Defect> defects(Map<String, XML> pkg) {
        LinkedList<Defect> defects = new LinkedList<Defect>();
        Map<XML, List<String>> existing = this.existingDefects(pkg);
        pkg.values().forEach(xmir -> {
            Xnav xml = new Xnav(xmir.inner());
            List present = (List)existing.get(xmir);
            xml.path("/program/metas/meta[head='unlint']/tail").map(xnav -> (String)xnav.text().get()).collect(Collectors.toSet()).stream().filter(unlint -> !present.contains(unlint)).forEach(unlint -> xml.path(String.format("program/metas/meta[head='unlint' and tail='%s']/@line", unlint)).map(xnav -> (String)xnav.text().get()).collect(Collectors.toList()).forEach(line -> defects.add(new Defect.Default(this.name(), Severity.WARNING, xml.element("program").attribute("name").text().orElse("unknown"), Integer.parseInt(line), String.format("Unlinting rule '%s' doesn't make sense, since there are no defects with it", unlint)))));
        });
        return defects;
    }

    @Override
    public String motive() throws IOException {
        return new IoCheckedText((Text)new TextOf((Input)new ResourceOf((CharSequence)String.format("org/eolang/motives/misc/%s.md", this.name())))).asString();
    }

    private Map<XML, List<String>> existingDefects(Map<String, XML> pkg) {
        HashMap<XML, List<String>> aggregated = new HashMap<XML, List<String>>(0);
        this.lints.forEach(wpl -> {
            try {
                Collection<Defect> defects = wpl.defects(pkg);
                pkg.values().forEach(program -> aggregated.merge((XML)program, (List<String>)new ListOf((Iterable)defects.stream().map(Defect::rule).collect(Collectors.toList())), (existing, incoming) -> {
                    existing.addAll(incoming);
                    return existing;
                }));
            }
            catch (IOException exception) {
                throw new IllegalStateException(String.format("IO operation failed while linting package of programs with %s", wpl.name()), exception);
            }
        });
        return aggregated;
    }
}

