/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.lints;

import com.jcabi.xml.XML;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.eolang.lints.Defect;
import org.eolang.lints.Lint;
import org.eolang.lints.Severity;

final class LtUnitTestMissing
implements Lint<Map<String, XML>> {
    LtUnitTestMissing() {
    }

    @Override
    public Collection<Defect> defects(Map<String, XML> pkg) throws IOException {
        LinkedList<Defect> defects = new LinkedList<Defect>();
        for (String name : pkg.keySet()) {
            if (name.endsWith("-tests")) continue;
            String lookup = String.format("%s-tests", name);
            if (pkg.containsKey(lookup)) continue;
            defects.add(new Defect.Default("unit-test-missing", Severity.WARNING, name, 0, String.format("Tests \"%s\" not found for \"%s\"", lookup, name)));
        }
        return defects;
    }

    @Override
    public String name() {
        return "unit-test-missing";
    }

    @Override
    public String motive() throws IOException {
        return "";
    }
}

