/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.lints;

import com.jcabi.xml.XML;
import java.io.IOException;
import java.util.Collection;
import org.cactoos.Input;
import org.cactoos.Text;
import org.cactoos.io.ResourceOf;
import org.cactoos.iterable.Filtered;
import org.cactoos.iterable.Mapped;
import org.cactoos.list.ListOf;
import org.cactoos.set.SetOf;
import org.cactoos.text.TextOf;
import org.cactoos.text.UncheckedText;
import org.eolang.lints.Defect;
import org.eolang.lints.Lint;
import org.eolang.lints.Severity;

final class LtIncorrectUnlint
implements Lint<XML> {
    private final Collection<String> names;

    LtIncorrectUnlint(Iterable<String> lints) {
        this.names = new SetOf(lints);
    }

    @Override
    public String name() {
        return "incorrect-unlint";
    }

    @Override
    public Collection<Defect> defects(XML entity) throws IOException {
        return new ListOf((Iterable)new Mapped(xml -> new Defect.Default(this.name(), Severity.ERROR, entity.xpath("/program/@name").stream().findFirst().orElse("unknown"), Integer.parseInt((String)xml.xpath("@line").get(0)), "Uselessly \"unlint\", because a lint with that name does not exist"), (Iterable)new Filtered(xml -> !this.names.contains(xml.xpath("tail/text()").get(0)), (Iterable)entity.nodes("/program/metas/meta[head='unlint']"))));
    }

    @Override
    public String motive() throws IOException {
        return new UncheckedText((Text)new TextOf((Input)new ResourceOf((CharSequence)"org/eolang/motives/errors/lt-incorrect-unlint.md"))).asString();
    }
}

