/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.lints;

import com.github.lombrozo.xnav.Filter;
import com.github.lombrozo.xnav.Xnav;
import com.jcabi.log.Logger;
import com.jcabi.xml.XML;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.cactoos.Input;
import org.cactoos.Text;
import org.cactoos.io.ResourceOf;
import org.cactoos.text.TextOf;
import org.cactoos.text.UncheckedText;
import org.eolang.lints.Defect;
import org.eolang.lints.Lint;
import org.eolang.lints.Severity;

final class LtIncorrectAlias
implements Lint<Map<String, XML>> {
    LtIncorrectAlias() {
    }

    @Override
    public String name() {
        return "incorrect-alias";
    }

    @Override
    public Collection<Defect> defects(Map<String, XML> pkg) {
        LinkedList<Defect> defects = new LinkedList<Defect>();
        pkg.values().forEach(xmir -> {
            Xnav xml = new Xnav(xmir.inner());
            List aliased = xml.path("/program/metas/meta[head='alias']").collect(Collectors.toList());
            for (Xnav alias : aliased) {
                String pointer = (String)alias.element("tail").text().get();
                List parts = alias.elements(new Filter[]{Filter.withName((String)"part")}).collect(Collectors.toList());
                String lookup = ((String)((Xnav)parts.get(parts.size() - 1)).text().get()).substring(2);
                if (pkg.containsKey(lookup)) continue;
                defects.add(new Defect.Default("incorrect-alias", Severity.CRITICAL, xml.element("program").attribute("name").text().orElse("unknown"), Integer.parseInt(alias.attribute("line").text().orElse("0")), Logger.format((String)"Alias \"%s\" points to \"%s\", but it's not in scope (%d): %[list]s", (Object[])new Object[]{pointer, lookup, pkg.size(), pkg.keySet()})));
            }
        });
        return defects;
    }

    @Override
    public String motive() throws IOException {
        return new UncheckedText((Text)new TextOf((Input)new ResourceOf((CharSequence)"org/eolang/motives/critical/incorrect-alias.md"))).asString();
    }
}

