/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.jucs;

import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.LinkedList;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.cactoos.Input;
import org.cactoos.Text;
import org.cactoos.io.ResourceOf;
import org.cactoos.text.TextOf;
import org.cactoos.text.UncheckedText;
import org.eolang.jucs.ClasspathSource;
import org.junit.jupiter.api.Named;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.support.AnnotationConsumer;

final class JucsProvider
implements ArgumentsProvider,
AnnotationConsumer<ClasspathSource> {
    private static final Pattern IS_FILE = Pattern.compile("^.+\\.[a-z]+$");
    private ClasspathSource annotation;

    JucsProvider() {
    }

    public void accept(ClasspathSource ant) {
        this.annotation = ant;
    }

    public Stream<? extends Arguments> provideArguments(ExtensionContext ctx) {
        return this.yamls("").stream();
    }

    private Collection<Arguments> yamls(String prefix) {
        String[] subs;
        LinkedList<Arguments> out = new LinkedList<Arguments>();
        String home = String.format("%s/%s", this.sanitized(), prefix);
        String folder = new UncheckedText((Text)new TextOf((Input)new ResourceOf((CharSequence)home))).asString();
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher(String.format("glob:%s", this.annotation.glob()));
        for (String sub : subs = folder.split("\n")) {
            Path path = Paths.get(String.format("%s%s", prefix, sub), new String[0]);
            if (matcher.matches(path)) {
                out.add(Arguments.of((Object[])new Object[]{Named.of((String)path.toString(), (Object)new UncheckedText((Text)new TextOf((Input)new ResourceOf((CharSequence)String.format("%s%s", home, sub)))).asString())}));
                continue;
            }
            if (IS_FILE.matcher(sub).matches()) continue;
            out.addAll(this.yamls(String.format("%s/", sub)));
        }
        return out;
    }

    private String sanitized() {
        int end;
        String path = this.annotation.value();
        int begin = 0;
        if (path.charAt(0) == '/') {
            begin = 1;
        }
        if (path.charAt((end = path.length()) - 1) == '/') {
            --end;
        }
        return path.substring(begin, end);
    }
}

