/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.phi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eolang.phi.AtAbsent;
import org.eolang.phi.AtNamed;
import org.eolang.phi.AtSimple;
import org.eolang.phi.Attr;
import org.eolang.phi.Data;
import org.eolang.phi.PhEta;
import org.eolang.phi.Phi;

public class PhDefault
implements Phi,
Cloneable {
    private Map<String, Attr> attrs = new HashMap<String, Attr>(0);
    private final List<String> order = new ArrayList<String>(0);

    public PhDefault() {
        this(new PhEta());
    }

    public PhDefault(Phi prnt) {
        this.add("\u03c1", new AtSimple(prnt));
    }

    public String toString() {
        ArrayList<String> list = new ArrayList<String>(this.attrs.size());
        list.add(String.format("_order=%s", this.order));
        for (Map.Entry<String, Attr> ent : this.attrs.entrySet()) {
            int idx = this.order.indexOf(ent.getKey());
            list.add(String.format("%s%s=%s", ent.getKey(), idx >= 0 ? String.format("(%d)", idx) : "", ent.getValue().toString().replace("\n", "\n  ")));
        }
        return String.format("%s#%d:{\n  %s\n}", this.getClass().getCanonicalName(), this.hashCode(), String.join((CharSequence)"\n  ", list));
    }

    @Override
    public final Phi copy() {
        try {
            PhDefault copy = (PhDefault)PhDefault.class.cast(this.clone());
            HashMap<String, Attr> map = new HashMap<String, Attr>(this.attrs.size());
            for (Map.Entry<String, Attr> ent : this.attrs.entrySet()) {
                map.put(ent.getKey(), ent.getValue().copy(copy));
            }
            copy.attrs = map;
            return copy;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public final Attr attr(int pos) {
        if (this.order.isEmpty()) {
            throw new Attr.Exception("There are no attributes here");
        }
        int idx = pos >= this.order.size() ? this.order.size() - 1 : pos;
        return this.attr(this.order.get(idx));
    }

    @Override
    public final Attr attr(String name) {
        Attr attr = this.attrs.get(name);
        if (attr == null) {
            Attr sub = this.attrs.get("\u03c6");
            if (sub == null) {
                attr = new AtNamed(String.format("%s#%s", this.getClass().getCanonicalName(), name), this, new AtAbsent(name, String.format(" among other %d attrs (%s)", this.attrs.size(), String.join((CharSequence)", ", this.attrs.keySet()))));
            } else {
                attr = sub.get().attr(name);
                if (!(attr instanceof AtAbsent)) {
                    attr = new AtChild(attr, this);
                }
            }
        }
        return attr;
    }

    protected final void add(String name, Attr attr) {
        if (name.matches("^[a-z].*$")) {
            this.order.add(name);
        }
        this.attrs.put(name, new AtNamed(String.format("%s#%s", this.getClass().getCanonicalName(), name), this, attr));
    }

    private static final class AtChild
    implements Attr {
        private final Attr origin;
        private final Phi parent;

        AtChild(Attr attr, Phi prnt) {
            this.origin = attr;
            this.parent = prnt;
        }

        @Override
        public Attr copy(Phi self) {
            return new AtChild(this.origin.copy(self), this.parent);
        }

        @Override
        public Phi get() {
            Phi phi = this.origin.get();
            if (!(phi instanceof Data)) {
                phi.attr("\u03c1").put(this.parent);
            }
            return phi;
        }

        @Override
        public void put(Phi phi) {
            this.origin.put(phi);
        }
    }
}

