/*
 * Decompiled with CFR 0.152.
 */
package org.eolang;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.function.Supplier;
import org.eolang.BytesOf;

public final class VerboseBytesAsString
implements Supplier<String> {
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    private final byte[] data;

    public VerboseBytesAsString(byte[] data) {
        this.data = Arrays.copyOf(data, data.length);
    }

    @Override
    public String get() {
        String result;
        switch (this.data.length) {
            case 0: {
                result = "[<no bytes>]";
                break;
            }
            case 1: {
                result = String.format("[0x%02X] = %s", this.data[0], this.data[0] != 0);
                break;
            }
            case 8: {
                BytesOf bytes = new BytesOf(this.data);
                result = String.format("[0x%s] = %s, or \"%s\")", this.toHex(), bytes.asNumber(), this.escaped());
                break;
            }
            default: {
                result = String.format("[0x%s] = \"%s\"", this.toHex(), this.escaped());
            }
        }
        return result;
    }

    private String toHex() {
        char[] chars = new char[this.data.length * 2];
        for (int idx = 0; idx < this.data.length; ++idx) {
            int value = this.data[idx] & 0xFF;
            chars[idx * 2] = HEX_ARRAY[value >>> 4];
            chars[idx * 2 + 1] = HEX_ARRAY[value & 0xF];
        }
        return new String(chars).replaceAll("(.{8})", "$1-");
    }

    private String escaped() {
        char[] chars = new String(this.data, StandardCharsets.UTF_8).toCharArray();
        StringBuilder out = new StringBuilder(chars.length);
        for (char chr : chars) {
            if (chr < ' ' || chr > '\u007f') {
                out.append(String.format("\\u%04x", chr));
                continue;
            }
            out.append(chr);
        }
        return out.toString();
    }
}

