/*
 * Decompiled with CFR 0.152.
 */
package org.eolang;

import EOorg.EOeolang.EOerror;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eolang.Bytes;
import org.eolang.BytesOf;
import org.eolang.ExFailure;
import org.eolang.Phi;

public final class Dataized {
    private final Phi phi;
    private final Logger logger;

    public Dataized(Phi src) {
        this(src, Logger.getLogger(Dataized.class.getName()));
    }

    public Dataized(Phi src, Logger log) {
        this.phi = src;
        this.logger = log;
    }

    public byte[] take() {
        try {
            return this.phi.delta();
        }
        catch (EOerror.ExError ex) {
            ArrayList<String> raw = new ArrayList<String>(ex.messages().size());
            raw.addAll(ex.messages());
            Collections.reverse(raw);
            Phi enc = ex.enclosure();
            if ("org.eolang.go.to.token.jump".equals(enc.forma())) {
                throw new EOerror.ExError(enc);
            }
            if (String.format("%s.org.eolang.string", "\u03a6").equals(enc.forma())) {
                raw.add(String.format("\"%s\"", new Dataized(enc).take(String.class)));
            }
            String fmt = String.format("%%%dd) %%s", (int)Math.log10(raw.size()) + 1);
            ArrayList<String> clean = new ArrayList<String>(raw.size());
            int idx = 1;
            for (String line : raw) {
                clean.add(String.format(fmt, idx, line));
                ++idx;
            }
            this.logger.log(Level.SEVERE, String.format("Dataized to org.eolang.error with %s inside, at:%n  \u21e2 %s", enc.forma(), String.join((CharSequence)"\n  \u21e2 ", clean)));
            throw new EOerror.ExError(enc);
        }
    }

    public <T> T take(Class<T> type) {
        Object res;
        if (type.equals(Long.class)) {
            res = new BytesOf(this.take()).asNumber(Long.class);
        } else if (type.equals(Double.class)) {
            res = this.asNumber();
        } else if (type.equals(Integer.class)) {
            res = new BytesOf(this.take()).asNumber(Integer.class);
        } else if (type.equals(Short.class)) {
            res = new BytesOf(this.take()).asNumber(Short.class);
        } else if (type.equals(byte[].class)) {
            res = this.take();
        } else if (type.equals(String.class)) {
            res = this.asString();
        } else if (type.equals(Boolean.class)) {
            res = this.asBool();
        } else {
            throw new IllegalArgumentException(String.format("Unknown type \"%s\", bytes are: %s", type.getCanonicalName(), Arrays.toString(this.asBytes().take())));
        }
        return type.cast(res);
    }

    public String asString() {
        return new String(this.take(), StandardCharsets.UTF_8);
    }

    public Double asNumber() {
        return new BytesOf(this.take()).asNumber();
    }

    public Boolean asBool() {
        byte[] weak = this.take();
        if (weak.length != 1) {
            throw new ExFailure("Can't dataize given bytes of length > 1 to boolean, bytes are: %s", Arrays.toString(weak));
        }
        return weak[0] == 1;
    }

    public Bytes asBytes() {
        return new BytesOf(this.take());
    }
}

