/*
 * Decompiled with CFR 0.152.
 */
package EOorg.EOeolang.EOfs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import org.eolang.ExFailure;

final class Files {
    static final Files INSTANCE = new Files();
    private final ConcurrentHashMap<String, Object[]> streams = new ConcurrentHashMap(0);

    private Files() {
    }

    void open(String name) throws IOException {
        Path path = Paths.get(name, new String[0]);
        this.streams.putIfAbsent(name, new Object[]{java.nio.file.Files.newInputStream(path, new OpenOption[0]), java.nio.file.Files.newOutputStream(path, StandardOpenOption.APPEND)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] read(String name, int size) throws IOException {
        ConcurrentHashMap<String, Object[]> concurrentHashMap = this.streams;
        synchronized (concurrentHashMap) {
            int character;
            int processed;
            if (!this.streams.containsKey(name)) {
                throw new ExFailure("File input stream with name %s is absent, can't read", name);
            }
            byte[] read = new byte[size];
            InputStream input = (InputStream)this.streams.get(name)[0];
            for (processed = 0; processed < size && (character = input.read()) != -1; ++processed) {
                read[processed] = (byte)character;
            }
            return Arrays.copyOf(read, processed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(String name, byte[] buffer) throws IOException {
        ConcurrentHashMap<String, Object[]> concurrentHashMap = this.streams;
        synchronized (concurrentHashMap) {
            if (!this.streams.containsKey(name)) {
                throw new ExFailure("File output stream with name %s is absent, can't read", name);
            }
            ((OutputStream)this.streams.get(name)[1]).write(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(String name) throws IOException {
        ConcurrentHashMap<String, Object[]> concurrentHashMap = this.streams;
        synchronized (concurrentHashMap) {
            if (!this.streams.containsKey(name)) {
                throw new ExFailure("File streams with name %s is absent, can't close", name);
            }
            ((InputStream)this.streams.get(name)[0]).close();
            ((OutputStream)this.streams.get(name)[1]).close();
            this.streams.remove(name);
        }
    }
}

